%def_disable snapshot

%define ver_major 3.32
%define xdg_name org.gnome.Notes
%define _libexecdir %_prefix/libexec
%def_enable zeitgeist

Name: bijiben
Version: %ver_major.2
Release: alt1

Summary: Note editor for GNOME
License: LGPLv3+
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Bijiben

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.28
%define gtk_ver 3.11.4
%define tracker_ver 0.18
%define eds_ver 3.19.90

Requires: dconf tracker >= %tracker_ver

BuildRequires(pre): meson rpm-build-xdg
BuildRequires: yelp-tools libappstream-glib-devel
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: tracker-devel >= %tracker_ver
BuildRequires: libxml2-devel libwebkit2gtk-devel
BuildRequires: libgnome-online-accounts-devel libuuid-devel
BuildRequires: evolution-data-server-devel >= %eds_ver libical-devel libicu-devel
%{?_enable_zeitgeist:BuildRequires: libzeitgeist2.0-devel}

%description
Bijiben is an attempt to design an intuitive note editor with strong
desktop integration.

%prep
%setup

%build
%meson \
	%{?_enable_zeitgeist:-Dzeitgeist=true} \
	-Dupdate_mimedb=false
# SMP-incompatible build
%meson_build -j 1

%install
%meson_install
%find_lang --with-gnome %name

%check
%meson_test

%files -f %name.lang
%_bindir/%name
%_libexecdir/%name-shell-search-provider
%_desktopdir/%xdg_name.desktop
%_datadir/%name/
%_iconsdir/hicolor/*/*/%{xdg_name}*.svg
%_datadir/gnome-shell/search-providers/%xdg_name-search-provider.ini
%_datadir/dbus-1/services/%xdg_name.SearchProvider.service
%_xdgmimedir/packages/%xdg_name.xml
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.%name.enums.xml
%_datadir/metainfo/%xdg_name.appdata.xml
%doc README AUTHORS NEWS

%changelog
