%define _localstatedir %_var

Name: bird
Version: 1.6.8
Release: alt2
Summary: BIRD Internet Routing Daemon

Group: Networking/Other
License: GPL
URL: http://bird.network.cz

# Cloned from git://git.nic.cz/bird.git
Source: %name-%version.tar
Source1: %name.init
Source2: %name.service
Source3: %{name}6.init
Source4: %{name}6.service

Patch: %name-%version-alt.patch

Packager: Vladimir Lettiev <crux@altlinux.ru>

BuildRequires: libreadline-devel libncurses-devel flex glibc-kernheaders OpenSP linuxdoc-tools

%description
BIRD is an Internet Routing Daemon designed to support all the routing
technology used in the today's Internet or planned to be used in near
future and to have a clean extensible architecture allowing new routing
protocols to be incorporated easily. Among other features, BIRD supports:

 * both IPv4 and IPv6 protocols
 * multiple routing tables
 * the Border Gateway Protocol (BGPv4)
 * the Routing Information Protocol (RIPv2)
 * the Open Shortest Path First protocol (OSPFv2)
 * a virtual protocol for exchange of routes between different routing
   tables on a single host
 * a command-line interface allowing on-line control and inspection of
   status of the daemon
 * soft reconfiguration (no need to use complex online commands to
   change the configuration, just edit the configuration file and notify
   BIRD to re-read it and it will smoothly switch itself to the new
   configuration, not disturbing routing protocols unless they are
   affected by the configuration changes)
 * a powerful language for route filtering

BIRD has been developed at the Faculty of Math and Physics, Charles
University, Prague, Czech Republic as a student project. It can be
freely distributed under the terms of the GNU General Public License.

%package -n bird6
Group: Networking/Other
Summary: BIRD Internet Routing Daemon, ipv6 enabled
Requires: %name = %version-%release
%description -n bird6
%summary

%prep
%setup
%patch -p1

%build
%autoreconf
%define _configure_script ../configure

# gcc detects overflow in strncpy at proto/rip/auth.c:134
# but it's false alarm, relax gcc
export CFLAGS="%optflags -D_FORTIFY_SOURCE=1"

mkdir build-bird6
pushd build-bird6
%configure --enable-ipv6 --with-protocols=all
%make_build
popd

mkdir build-bird4
pushd build-bird4
%configure --with-protocols=all
%make_build
popd

pushd doc
    make prog.sgml
    ./sgml2html prog.sgml
    ./sgml2html bird.sgml
popd

%install
%makeinstall -C build-bird6
%makeinstall -C build-bird4

install -pD -m755 %SOURCE1 %buildroot%_initdir/%name
install -pD -m644 %SOURCE2 %buildroot%_unitdir/%name.service
install -pD -m755 %SOURCE3 %buildroot%_initdir/%{name}6
install -pD -m644 %SOURCE4 %buildroot%_unitdir/%{name}6.service

%post
%post_service bird

%preun
%preun_service bird

%post -n bird6
%post_service bird6

%preun -n bird6
%preun_service bird6

%files
%_initdir/%name
%_unitdir/%name.service
%config(noreplace) %_sysconfdir/%name.conf
%_sbindir/%name
%_sbindir/%{name}c
%_sbindir/%{name}cl
%doc NEWS README doc/*.html

%files -n bird6
%_initdir/%{name}6
%_unitdir/%{name}6.service
%config(noreplace) %_sysconfdir/%{name}6.conf
%_sbindir/%{name}6
%_sbindir/%{name}c6
%_sbindir/%{name}cl6

%changelog
