%define _unpackaged_files_terminate_build 0
Name: btrfs-progs
Version: 5.9
Release: alt1

Summary: Utilities for managing the Btrfs filesystem
License: GPLv2
Group: System/Kernel and hardware
Url: http://btrfs.wiki.kernel.org/
Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires: libacl-devel libe2fs-devel libuuid-devel zlib-devel libblkid-devel libattr-devel liblzo2-devel asciidoc xmlto libzstd-devel libudev-devel

%description
Btrfs (B-tree FS or usually pronounced "Butter FS") is a copy-on-write
file system for Linux. It was created as a response to the ZFS filesystem,
in order to replace the ext3 file system while removing a number of its
limitations, particularly with respect to file size, total file system size
and filesystem check duration; it is also expected to implement modern
filesystem features not supported by ext3, like writable snapshots,
snapshots of snapshots, builtin RAID support, and subvolumes. In addition,
Btrfs claims a "focus on fault tolerance, repair and easy administration.

This package contains utilities for managing the Btrfs filesystem

%package -n libbtrfs-devel
Summary:	btrfs filesystem-specific libraries and headers
Group:		Development/C
Requires:	libbtrfs = %version-%release
Provides:	%name-devel

%description -n libbtrfs-devel
btrfs-progs-devel contains the libraries and header files needed to
develop btrfs filesystem-specific programs.

You should install btrfs-progs-devel if you want to develop
btrfs filesystem-specific programs.


%package -n libbtrfs
Summary:	btrfs filesystem-specific libraries and headers
Group:		System/Kernel and hardware

%description -n libbtrfs
btrfs-progs-devel contains shared libraries needed to
btrfs filesystem-specific programs.


%prep
%setup -q
%patch0 -p1

%build
autoreconf -fisv -I m4
automake --add-missing ||:
%configure --disable-python \
	   --disable-static \
	   --with-pkgconfigdir=%_pkgconfigdir \
	   #
%make_build

%install
%makeinstall_std bindir=/sbin libdir=/%_lib incdir=/%_includedir/
mkdir -p %buildroot%_libdir %buildroot%_bindir
LIBNAME=`basename \`ls $RPM_BUILD_ROOT/%{_lib}/libbtrfs.so.*.*\``
ln -s ../../%_lib/$LIBNAME %buildroot%_libdir/libbtrfs.so 
ln -s ../../sbin/btrfs %buildroot%_bindir/btrfs
rm -f %buildroot/%{_lib}/libbtrfs.so
rm -f %buildroot/%{_lib}/libbtrfsutil.so

%files
/sbin/*
%_bindir/btrfs
%_bindir/*
%_udevrulesdir/*.rules
%_man8dir/*
%_man5dir/*

%files -n libbtrfs
/%_lib/*.so.*

%files -n libbtrfs-devel
%_libdir/*.so
%_pkgconfigdir/libbtrfsutil.pc
%_includedir/*

%changelog
