%def_enable static
%define EVR %{?epoch:%epoch:}%version-%release

Name: check
Version: 0.12.0
Release: alt1
Epoch: 20180202

Summary: A unit test framework for C
License: LGPL
Group: Development/C

Url: https://github.com/libcheck/check
Source: %name-%version.tar
Packager: Michael Shigorin <mike@altlinux.org>

Requires: info-install

%add_optflags %optflags_shared
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
Check is a unit test framework for C. It features a simple
interface for defining unit tests, putting little in the way
of the developer. Tests are run in a separate address space,
so Check can catch both assertion failures and code errors that
cause segmentation faults or other signals. The output from unit
tests can be used within source code editors and IDEs.

%package -n lib%name
Summary: A unit test framework for C (core library)
Group: Development/C
Conflicts: %name < 20070219:0.9.5-alt4

%description -n lib%name
Check is a unit test framework for C.

This package contains check library.

%package -n lib%name-devel
Summary: A unit test framework for C (development headers)
Group: Development/C
Requires: lib%name = %EVR
Conflicts: %name < 20070219:0.9.5-alt4

%description -n lib%name-devel
Check is a unit test framework for C.

This package contains library header files needed to build
software with libcheck.

%if_enabled static
%package -n lib%name-devel-static
Summary: A unit test framework for C (static library)
Group: Development/C
Requires: lib%name = %EVR
Conflicts: %name < 20070219:0.9.5-alt4

%description -n lib%name-devel-static
Check is a unit test framework for C.

This package contains a static development library.
%endif

%prep
%setup

%build
%autoreconf
%configure %{subst_enable static}
%make_build

%install
%makeinstall_std

%files
%_bindir/checkmk
%_man1dir/checkmk.1*

%files -n lib%name
%doc AUTHORS NEWS THANKS TODO
%_docdir/%name
%exclude %_docdir/%name/example
%_libdir/*.so.*
%_infodir/*info*

%files -n lib%name-devel
%doc %_docdir/%name/example
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/aclocal/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
