# vim: set ft=spec: -*- rpm-spec -*-
%define        pkgname chef

Name:          %pkgname
Version:       15.2.19
Release:       alt1
Summary:       Clients for the chef systems integration framework
Group:         Networking/Other
License:       Apache-2.0
Url:           https://www.chef.io/
%vcs           https://github.com/opscode/chef.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
Source1:       chef-client.init
Source2:       chef-client.service
Source3:       chef-client.default
Source4:       chef-client.rb

BuildRequires(pre): rpm-build-ruby

%gem_replace_version highline ~> 2.0
%gem_replace_version train-core ~> 3.0
%add_findreq_skiplist %ruby_gemslibdir/**/*

%description
Chef is a systems integration framework and configuration management
library written in Ruby. Chef provides a Ruby library and API that can
be used to bring the benefits of configuration management to an entire
infrastructure.

Chef can be run as a client (chef-client) to a server, or run as a
standalone tool (chef-solo). Configuration recipes are written in a pure
Ruby DSL.

This package contains the chef-client, chef-solo and knife binaries as
well as the chef library.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%package       -n gem-%pkgname-config
Summary:       Chef's default configuration and config loading
Group:         Development/Ruby
BuildArch:     noarch

%description   -n gem-%pkgname-config
Chef's default configuration and config loading.

%description   -n gem-%pkgname-config -l ru_RU.UTF8
Настройки для самоцвета %gemname.


%package       -n gem-%pkgname-config-doc
Summary:       Documentation files for %gemname-config gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   -n gem-%pkgname-config-doc
Documentation files for %gemname-config gem.

%description   -n gem-%pkgname-config-doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname-config.


%package       -n gem-%pkgname-bin
Summary:       Chef-branded binstubs for chef-client
Group:         Development/Ruby
BuildArch:     noarch

%description   -n gem-%pkgname-bin
Chef-branded binstubs for chef-client.

%description   -n gem-%pkgname-bin -l ru_RU.UTF8
Исполняемые заглушки для самоцвета %gemname.


%package       -n gem-%pkgname-bin-doc
Summary:       Documentation files for %gemname-bin gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   -n gem-%pkgname-bin-doc
Documentation files for %gemname-bin gem.

%description   -n gem-%pkgname-bin-doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname-bin.


%prep
%setup

%build
%ruby_build --ignore=standalone_cookbook,omnibus,kitchen-tests,win32-eventlog --use=chef --join=lib:bin

%install
%ruby_install

# Install init scripts
install -Dm 0755 %SOURCE1 %buildroot%_initdir/chef-client
install -Dm 0644 %SOURCE2 %buildroot%_unitdir/chef-client.service
install -Dm 0644 %SOURCE3 %buildroot%_sysconfdir/sysconfig/chef-client
install -Dm 0640 %SOURCE4 %buildroot%_sysconfdir/chef/client.rb

mkdir -p %buildroot%_var/log/chef
mkdir -p %buildroot%_var/lib/chef
mkdir -p %buildroot%_var/cache/chef
mkdir -p %buildroot/run/chef

%check
%ruby_test

%files
%doc README*
%ruby_gemspecdir/chef-%version.gemspec
%ruby_gemslibdir/chef-%version
%_bindir/*
%_initdir/chef-client
%_unitdir/chef-client.service
%_sysconfdir/sysconfig/chef-client
%config(noreplace) %attr(0640, root, _chef) %_sysconfdir/chef/client.rb
%dir %attr(0750, root, _chef) %_sysconfdir/chef
%dir %attr(0750, _chef, _chef) %_var/log/chef
%dir %attr(0750, _chef, _chef) %_var/lib/chef
%dir %attr(0750, _chef, _chef) %_var/cache/chef

%files         -n gem-%pkgname-config
%ruby_gemspecdir/chef-config-%version.gemspec
%ruby_gemslibdir/chef-config-%version

%files         -n gem-%pkgname-bin
%ruby_gemspecdir/chef-bin-%version.gemspec
%ruby_gemslibdir/chef-bin-%version

%files         doc
%ruby_gemsdocdir/chef-%version

%files         -n gem-%pkgname-config-doc
%ruby_gemsdocdir/chef-config-%version

%files         -n gem-%pkgname-bin-doc
%ruby_gemsdocdir/chef-bin-%version

%pre
getent group _chef  >/dev/null || groupadd -r _chef
getent passwd _chef >/dev/null || useradd  -r -g _chef -d %_var/lib/chef -s /sbin/nologin -c "Opscode Chef Daemon" _chef

%changelog
