%def_disable gtk_doc

Name: cinnamon
Version: 4.2.3
Release: alt2

Summary: A Linux desktop which provides advanced innovative features and a traditional user experience.
License: GPLv2+
Group: Graphical desktop/GNOME

Url: http://cinnamon.linuxmint.com
# To generate tarball
# wget https://github.com/linuxmint/Cinnamon/tarball/1.6.4 -O cinnamon-1.6.4.tar.gz
Source0: %name-%version.tar
Source2: org.%name.settings-users.policy
Source3: polkit-%name-authentication-agent-1.desktop

Patch: %name-%version-%release.patch

%add_python3_path %_datadir/%name
%set_typelibdir %_libdir/%name

%define gtk_ver 3.12.0
%define gi_ver 0.10.1
%define muffin_ver 4.0.3
%define json_glib_ver 0.13.2
%define cjs_ver 4.0.0
%define polkit_ver 0.100
%define folks_ver 0.5.2
%define bt_ver 3.0.0

Provides: desktop-notification-daemon

Requires: dconf
Requires: upower
Requires: polkit >= %polkit_ver
Requires: polkit-gnome
# needed for session files
Requires: cinnamon-session >= 2.6.2
# needed for on-screen keyboard
Requires: caribou
Requires: cinnamon-freedesktop-menu
Requires: %name-data = %version-%release
Requires: muffin >= %muffin_ver
Requires: libmuffin-gir >= %muffin_ver
Requires: %name-translations
Requires: mintlocale
Requires: gst-plugins-base1.0

Requires: typelib(Soup)

# needed to install applets
Requires: gettext-tools

BuildRequires(pre): rpm-build-gir >= 0.7.3 rpm-build-python3
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libcjs-devel >= %cjs_ver
BuildPreReq: libjson-glib-devel >= %json_glib_ver
BuildRequires: gcc-c++
BuildRequires: libcinnamon-desktop-devel libgnome-keyring-devel libcinnamon-menus-devel
BuildRequires: libstartup-notification-devel libcinnamon-desktop-gir-devel
BuildRequires: libpolkit-devel libupower-devel libgudev-devel libsoup-devel libnm-devel libnm-gir-devel
BuildRequires: libcanberra-gtk3-devel libcroco-devel
BuildRequires: gobject-introspection >= %gi_ver libupower-gir-devel libgudev-gir-devel libsoup-gir-devel
BuildRequires: libcinnamon-menus-gir-devel
BuildRequires: gst-plugins1.0-devel

# for barriers
BuildRequires: libXfixes-devel >= 5.0
# used in unused BigThemeImage
BuildRequires: librsvg-devel
BuildRequires: libmuffin-devel >= %muffin_ver
BuildRequires: libmuffin-gir-devel >= %muffin_ver
BuildRequires: libdrm-devel libgbm-devel
BuildRequires: libpulseaudio-devel

BuildRequires: desktop-file-utils
BuildRequires: gtk-doc gnome-common intltool
BuildRequires: at-spi2-atk-devel
BuildRequires: rpm-build-xdg

%description
Cinnamon is a Linux desktop which provides advanced innovative features
and a traditional user experience.

The desktop layout is similar to Gnome 2. The underlying technology is
forked from Gnome Shell. The emphasis is put on making users feel at
home and providing them with an easy to use and comfortable desktop
experience.

%package data
Summary: Arch independent files for Cinnamon
Group: Graphical desktop/GNOME
BuildArch: noarch
Provides: python3(cme)
Provides: python3(Spices)
# https://bugzilla.altlinux.org/36995
Requires: python3-module-PAM
Requires: python3-module-xapps-overrides

%description data
This package provides noarch data needed for Cinnamon to work.

%package devel-doc
Summary: Development doc package for Cinnamon
Group: Development/Documentation
BuildArch: noarch

%description devel-doc
Development docs package for Cinnamon.

%prep
%setup -n %name-%version
%patch -p1

rm -rf debian

%build
%autoreconf
%configure \
	--disable-static \
	--enable-compile-warnings=yes \
	--without-ca-certificates \
	%{?_disable_gtk_doc:--disable-gtk-doc}
%make_build

%install
%makeinstall_std

# Remove .la file
rm -rf %buildroot/%_libdir/cinnamon/libcinnamon.la

rm -f %buildroot/%_man1dir/gnome-session-cinnamon.1
rm -f %buildroot/%_man1dir/gnome-session-cinnamon2d.1

desktop-file-validate %buildroot%_desktopdir/cinnamon.desktop
desktop-file-validate %buildroot%_desktopdir/cinnamon2d.desktop

desktop-file-install                                 \
 --add-category="Utility"                            \
 --remove-category="DesktopSettings"                 \
 --remove-key="Encoding"                             \
 --add-only-show-in="GNOME"                          \
 --delete-original                                   \
 --dir=%buildroot%_datadir/applications       \
 %buildroot%_desktopdir/cinnamon-settings.desktop

#install polkit files
install -m 0755 -d %buildroot/%_datadir/polkit-1/actions/
install -D -p -m 0644 %SOURCE2 %buildroot/%_datadir/polkit-1/actions/
install -D -p -m 0644 %SOURCE3 %buildroot/%_datadir/applications/

# Clean-up requires

# cinnamon/files/usr/share/cinnamon/cinnamon-settings/modules/cs_themes.py
# from gi.repository.Gtk import SizeGroup, SizeGroupMode
%filter_from_requires /python3[(]gi.repository.Gtk[)]/d

# There is already registered upstream issue https://github.com/linuxmint/muffin/issues/199
# But untill it will be fixed by Cinnamon devs we handle it manually.
# Note: to handle dependency we require libmuffin-gir explicitly
%filter_from_requires /typelib(Meta)/d

# Remove from explicit dependencies muffin private libraries. By default
# RPM doesn't generate this provides for muffin but generates requires
# for them in cinnamon debuginfo packages.
%filter_from_requires /libmuffin-clutter/d
%filter_from_requires /libmuffin-cogl/d

%files
%exclude %_bindir/%{name}-launcher
%_bindir/*
%_libdir/cinnamon/
%dir %_libexecdir/cinnamon/
%_libexecdir/cinnamon/cinnamon-hotplug-sniffer
%_libexecdir/cinnamon/cinnamon-perf-helper

%files data
%exclude %_xdgmenusdir/cinnamon-applications-merged
%exclude %_xdgmenusdir/cinnamon-applications.menu
%exclude %_datadir/xsessions/*.desktop
%exclude %_datadir/cinnamon-session/sessions/*.session
%_datadir/cinnamon/
%_datadir/dbus-1/services/org.Cinnamon.HotplugSniffer.service
%_datadir/dbus-1/services/org.Cinnamon.Melange.service
%_datadir/dbus-1/services/org.Cinnamon.Slideshow.service
%_datadir/desktop-directories/*.directory
%_datadir/glib-2.0/schemas/*.xml
%_datadir/polkit-1/actions/org.cinnamon.settings-users.policy
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/*/*.svg
%_man1dir/*.1.*

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%changelog
