# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-java
BuildRequires: unzip
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-generic-compat sonatype-oss-parent
%define fedora 25
# %%name or %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name clojure
%define version 1.7.0
%global project     clojure
%global groupId     org.clojure
%global artifactId  clojure
%global archivename %{project}-%{artifactId}
%global full_version %{version}

Name:           clojure
Epoch:          1
Version:        1.7.0
Release:        alt2_1jpp8
Summary:        A dynamic programming language that targets the Java Virtual Machine

Group:          Development/Java
License:        EPL
URL:            http://clojure.org/
Source0:        https://github.com/%{name}/%{name}/archive/%{name}-%{full_version}.zip

Source1:        clojure.sh

BuildArch:      noarch

BuildRequires:  maven-local
BuildRequires:  maven-local
BuildRequires:  ant >= 1.6
BuildRequires:  objectweb-asm

%if 0%{?fedora} > 20
%else
%endif

Requires:       objectweb-asm
Source44: import.info

%description 
Clojure is a dynamic programming language that targets the Java
Virtual Machine. It is designed to be a general-purpose language,
combining the approachability and interactive development of a
scripting language with an efficient and robust infrastructure for
multithreaded programming. Clojure is a compiled language - it
compiles directly to JVM bytecode, yet remains completely
dynamic. Every feature supported by Clojure is supported at
runtime. Clojure provides easy access to the Java frameworks, with
optional type hints and type inference, to ensure that calls to Java
can avoid reflection.

%prep
%setup -q -n %{archivename}-%{full_version}

%build
ant -Dmaven.test.skip=1

%mvn_artifact pom.xml %{name}.jar

%install
# jar - link to prefix'd jar so that java stuff knows where to look
install -d -m 755 %{buildroot}%{_javadir}
install -d -m 755 %{buildroot}%{_mavenpomdir}
install -pm 644 %{name}.jar %{buildroot}%{_javadir}/%{name}.jar
install -pm 644 pom.xml %{buildroot}%{_mavenpomdir}/JPP-%{name}.pom

# startup script
install -d -m 755 %{buildroot}%{_bindir}
install -pm 755 %{SOURCE1} %{buildroot}%{_bindir}/%{name}

%mvn_install

%files -f .mfiles
%doc epl-v10.html changes.md readme.txt 
%{_mavenpomdir}/*
%{_javadir}/%{name}.jar
%{_bindir}/%{name}

%changelog
