Summary:        Creates a common metadata repository
Name:           createrepo_c
Version:        0.11.0
Release:        alt1.1
Group:          System/Configuration/Packaging
License:        GPLv2+
URL:            https://github.com/rpm-software-management/createrepo_c
Packager:       Alexey Gladkov <legion@altlinux.ru>

Source0:        %name-%version.tar
Patch0:         %name-set-versions.patch

BuildRequires(pre): rpm-macros-cmake

BuildRequires:  cmake
BuildRequires:  gcc
BuildRequires:  doxygen
BuildRequires:  expat-devel
BuildRequires:  libmagic-devel
BuildRequires:  glib2-devel
BuildRequires:  libcurl-devel
BuildRequires:  libxml2-devel
BuildRequires:  libssl-devel
BuildRequires:  librpm-devel
BuildRequires:  libsqlite3-devel
BuildRequires:  bzip2-devel
BuildRequires:  liblzma-devel
BuildRequires:  zlib-devel

BuildRequires:  python3-devel
BuildRequires:  python3-module-nose

Requires:   lib%name = %version-%release

%description
C implementation of Createrepo.
A set of utilities (createrepo_c, mergerepo_c, modifyrepo_c)
for generating a common metadata repository from a directory of
rpm packages and maintaining it.

%package -n lib%name
Summary:    Library for repodata manipulation
Group:      System/Libraries
Provides:   %name-libs

%description -n lib%name
Libraries for applications using the createrepo_c library
for easy manipulation with a repodata.

%package devel
Summary:    Library for repodata manipulation
Group:      Development/C
Requires:   lib%name = %version-%release

%description devel
This package contains the createrepo_c C library and header files.
These development files are for easy manipulation with a repodata.

%prep
%setup -q
%patch0 -p1

%build
export CMAKE_CXX_FLAGS="%optflags"

%cmake -DPYTHON_DESIRED=3
%cmake_build

%install
%cmakeinstall_std

%files
%_bindir/*
%_man8dir/*

%files -n lib%name
%_libdir/lib%name.so.*

%files devel
%_libdir/*.so
%_libdir/pkgconfig/*.pc
%_includedir/%name

%changelog
