%define _unpackaged_files_terminate_build 1
%set_verify_elf_method strict

%define dbdir %_localstatedir/%name

Name: dhcpcd
Epoch: 1
Version: 8.1.9
Release: alt1

Summary: DHCP Client
License: BSD-2-Clause
Group: System/Servers

URL: https://roy.marples.name/projects/%name
Source: %name-%version.tar
Patch0: %name-%version-%release.patch

AutoReq: yes, noshell

Conflicts: etcnet < 0.9.10-alt6

# NetworkManager can use dhcpcd
Provides: nm-dhcp-client


%description
dhcpcd is an implementation of the DHCP client specified in RFC2131.

It gets the host information (IP address, netmask, broadcast address, etc.)
from a DHCP server and configures the network interface of the machine on
which it is running. It also tries to renew the lease time according to RFC2131.

%prep
%setup -q
%patch0 -p1

%build
%add_optflags -fpie
export LDFLAGS=-pie
%configure \
        --sbindir=/sbin \
        --rundir=/var/run \
        --libexecdir=/lib/%name \
        --dbdir=%dbdir \
        --serviceexists='[ -x %_initdir/"$1" ]' \
        --servicecmd='/sbin/service "$1" >/dev/null 2>&1' \
        --with-hook=ntp.conf \
        --with-hook=lookup-hostname \
        --enable-ipv4 \
        --enable-ipv6 \
		--enable-dhcp6 \
		--enable-auth \
		--enable-ipv4ll \
        --without-udev
%make_build

%install
%makeinstall_std BINMODE=0755

# These files changed their name/location since 7.0.0.
# Don't move lease files, they can be used and often removed when dhcpcd
# is exited.
%triggerpostun -- %name < 1:7.0.0
for f in duid secret; do
	if [ -e %_sysconfdir/dhcpcd.$f ] && [ ! -e %dbdir/$f ]; then
		echo "%_sysconfdir/dhcpcd.$f found, moving to %dbdir/$f"
		mv "%_sysconfdir/dhcpcd.$f" "%dbdir/$f"
	fi
done
if [ ! -e %dbdir/rdm_monotonic ] && [ -e %dbdir/dhcpcd-rdm.monotonic ]; then
	mv %dbdir/dhcpcd-rdm.monotonic %dbdir/rdm_monotonic
fi

%files
/sbin/*
%_man8dir/*
%_man5dir/*
%config(noreplace) %_sysconfdir/%name.conf
%dir %_localstatedir/%name
%dir /lib/%name
%dir /lib/%name/%name-hooks
/lib/%name/%name-hooks/*
/lib/%name/%name-run-hooks

# Ingnore all additional hooks:
#   wpa_supplicant: wpa_supplicant should be handled by etcnet
#   tzupdate: it should use tzupdate but what about configuration files?
%exclude %_datadir/%name/

%changelog
