# Spec file for Dillo

Name: dillo
Version: 3.0.5
Release: alt3

Summary: a small FLTK-based web browser
Group: Networking/WWW
License: %gpl2plus
Url: http://www.dillo.org

Packager: Nikolay A. Fetisov <naf@altlinux.org>

# Patch for i18n:  http://teki.jpn.ph/pc/software/index-e.shtml
Source0: %name-%version.tar
Source1: %name-16.png
Source2: %name-32.png
Source3: %name-48.png
Source4: %name.desktop

Patch1:  %name-3.0.5-debian-fix-OpenSSL-1.1-detection.patch
Patch2:  %name-3.0.5-alt-ca_location_fix.patch

BuildRequires(pre): rpm-build-licenses


# Automatically added by buildreq on Sun Aug 19 2018
# optimized out: fontconfig glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config libX11-devel libcom_err-devel libkrb5-devel libstdc++-devel python-base python-modules python3 python3-base python3-dev ruby sh3 xorg-proto-devel zlib-devel
BuildRequires: gcc-c++ libfltk-devel libjpeg-devel libpng-devel libssl-devel
BuildRequires: libXrender-devel libXcursor-devel libXfixes-devel libXext-devel
BuildRequires: perl-libnet libXinerama-devel libXft-devel fontconfig-devel

%description
Dillo 3 is a graphical multi-platform web browser known for its
speed and small footprint. It is based on FLTK 1.3,
the Fast and Light Toolkit (FLTK).

Dillo aims to be small in resources, stable, developer-friendly,
usable, very fast, and extensible.

%prep
%setup -q

%patch1 -p1
%patch2

%build
%autoreconf
%configure  --enable-ipv6 \
            --enable-ssl \
            %nil

%make_build

%install
%makeinstall

mkdir -p -- %buildroot%_sysconfdir/%name
mv -- %buildroot%_sysconfdir/*rc %buildroot/%_sysconfdir/%name/

mkdir -p -- %buildroot%_miconsdir %buildroot%_liconsdir %buildroot%_niconsdir
install -m0644 -- %SOURCE1 %buildroot%_miconsdir/%name.png
install -m0644 -- %SOURCE2 %buildroot%_niconsdir/%name.png
install -m0644 -- %SOURCE3 %buildroot%_liconsdir/%name.png

mkdir -p -- %buildroot%_desktopdir
install -m 0644 -- %SOURCE4 %buildroot%_desktopdir/%name.desktop

rm -f -- doc/Makefile*

%find_lang %name

%files -f %name.lang
%_bindir/dillo
%_bindir/dillo-install-hyphenation
%_bindir/dpid
%_bindir/dpidc
%_libdir/dillo*

%doc AUTHORS ChangeLog COPYING INSTALL NEWS README doc/
%doc %_defaultdocdir/%name/user_help.html

%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/domainrc
%config(noreplace) %_sysconfdir/%name/keysrc
%config(noreplace) %_sysconfdir/%name/dpidrc
%config(noreplace) %_sysconfdir/%name/dillorc

%_miconsdir/%{name}*
%_niconsdir/%{name}*
%_liconsdir/%{name}*
%_desktopdir/%name.desktop
%_man1dir/dillo.1*

%changelog
