%define xdg_name org.gnome.EasyTAG
%def_enable nautilus

Name: easytag
Version: 2.4.3
Release: alt2

Summary: Audio files tag viewer/editor
Summary(ru_RU.UTF-8): Утилита для редактирования тегов звуковых файлов
Group: Sound
License: GPLv2+
Url: https://wiki.gnome.org/Apps/EasyTAG

Source: %name-%version.tar
#Patch: %name-%version-%release.patch

BuildRequires: rpm-build-gnome intltool gcc-c++
BuildRequires: xsltproc docbook-dtds docbook-style-xsl
BuildRequires: desktop-file-utils
BuildRequires: yelp-tools
BuildRequires: libappstream-glib-devel

BuildRequires: pkgconfig(gtk+-3.0) >= 3.2.1
BuildRequires: pkgconfig(ogg) >= 1.0 pkgconfig(vorbis) >= 1.0.1 pkgconfig(vorbisfile)
BuildRequires: pkgconfig(opus) >= 1.0 pkgconfig(opusfile)
BuildRequires: pkgconfig(speex)
BuildRequires: pkgconfig(flac) >= 1.1.4
BuildRequires: pkgconfig(id3tag) id3lib-devel
BuildRequires: pkgconfig(taglib) >= 1.9.1
BuildRequires: pkgconfig(wavpack) >= 4.40
BuildRequires: pkgconfig(gio-2.0) >= 2.32.0
%{?_enable_nautilus:BuildRequires: libnautilus-devel}

%description
EasyTAG is a utility for viewing, editing and writing the tags of MP4, MP3,
MP2, FLAC, Ogg Opus, Ogg Speex, Ogg Vorbis, MusePack and Monkey's Audio files.

EasyTAG is an utility for viewing, editing easily and quickly the ID3v1 ,
ID3v2, APE and OGG tags of your audio files, using a nice GTK+2 user interface.

%description -l ru_RU.UTF-8
EasyTAG - это утилита для просмотра и редактирования тегов ID3v1 и ID3v2
файлов MP4, MP3 MP2, FLAC, Ogg Opus, Ogg Speex, Ogg Vorbis, MusePack и
Monkey's звуковых файлов.

%prep
%setup
#%patch -p1

%build
%autoreconf
%configure \
	%{?_enable_nautilus:--enable-nautilus-actions}

%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%check
%make check

%files -f %name.lang
%_bindir/%name
%_desktopdir/%name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.enums.xml
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/*/apps/%name.*
%_iconsdir/hicolor/symbolic/apps/%name-symbolic.svg
%_datadir/metainfo/%name.appdata.xml

%if_enabled nautilus
%nautilus_extdir/*.so
%exclude %nautilus_extdir/*.la
%_datadir/metainfo/%name-nautilus.metainfo.xml
%endif

%_man1dir/%name.1*
%doc ChangeLog HACKING README THANKS TODO

%changelog
