%def_enable snapshot

%define _libexecdir %_prefix/libexec
%define xdg_name org.gnome.Empathy

%define ver_major 3.25
%def_disable static
%def_enable map
%def_enable goa
%if_enabled goa
%define mcp_dir %(pkg-config --variable=plugindir mission-control-plugins)
%endif
%def_enable geocode
%def_enable location
%def_enable gudev
%def_with cheese
%define gst_api_ver 1.0

Name: empathy
Version: %ver_major.90
Release: alt3

Summary: Instant Messaging Client for GNOME
License: GPL/LGPL
Group: Networking/Instant messaging
Url: https://live.gnome.org/Empathy

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Conflicts: telepathy-haze-aim
Obsoletes: libempathy libempathy-gtk python-module-empathy

%define intltool_ver 0.35.0
%define glib_ver 2.46
%define gtk_ver 3.9.4
%define clutter_ver 1.1.2
%define clutter_gst_ver 3.0.18
%define tp_glib_ver 0.23.2
%define tp_logger_ver 0.8.0
%define tp_gabble_ver 0.16.0
%define tp_haze_ver 0.6.0
%define tp_salut_ver 0.8.0
%define mission_control_ver 5.13.0
%define enchant_ver 1.2.0
%define check_ver 0.9.4
%define iso_codes_ver 0.35
%define notify_ver 0.7.3
%define canberra_ver 0.26
%define webkit_ver 2.10.1
%define geoclue2_ver 1.99.3
%define gcr_ver 3.3.90
%define champlain_ver 0.12.0
%define gnutls_ver 2.8.5
%define folks_ver 0.9.5
%define nst_ver 2.91.6
%define nm_ver 0.8.995
%define goa_ver 3.6.2
%define secret_ver 0.5
%define farstream_ver 0.2
%define geocode_ver 0.99.3
%define soup_ver 2.42

Requires: %name-data = %version-%release

Requires: telepathy-gabble >= %tp_gabble_ver
Requires: telepathy-salut >= %tp_salut_ver
Requires: telepathy-haze >= %tp_haze_ver
Requires: libtelepathy-mission-control >= %mission_control_ver
Requires: telepathy-logger >= %tp_logger_ver
Requires: farstream0.2 >= %farstream_ver
%{?_enable_location:Requires: geoclue2 >= %geoclue2_ver}

BuildRequires: intltool >= %intltool_ver gnome-common itstool
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libclutter-gtk3-devel >= %clutter_ver
BuildRequires: libclutter-gst3.0-devel >= %clutter_gst_ver
BuildRequires: libtelepathy-glib-devel >= %tp_glib_ver
BuildRequires: libfolks-devel >= %folks_ver
BuildRequires: libenchant-devel >= %enchant_ver
BuildRequires: libcheck-devel >= %check_ver
BuildRequires: iso-codes-devel >= %iso_codes_ver
BuildRequires: libnotify-devel >= %notify_ver
BuildRequires: libcanberra-gtk3-devel >= %canberra_ver
BuildRequires: libwebkit2gtk-devel >= %webkit_ver
BuildRequires: libsecret-devel >= %secret_ver
BuildRequires: gcr-libs-devel >= %gcr_ver
BuildRequires: libtelepathy-logger-devel >= %tp_logger_ver
BuildRequires: libgnutls-devel >= %gnutls_ver
BuildRequires: libgee0.8-devel gobject-introspection-devel libgtk+3-gir-devel
BuildRequires: libtelepathy-farstream-devel >= %farstream_ver
%{?_enable_map:BuildRequires: libchamplain-devel >= %champlain_ver  libchamplain-gtk3-devel >= %champlain_ver}
%{?_enable_goa:BuildRequires(pre): libtelepathy-mission-control-devel >= %mission_control_ver}
%{?_enable_goa:BuildRequires: libgnome-online-accounts-devel >= %goa_ver}
%{?_enable_location:BuildRequires: geoclue2-devel >= %geoclue2_ver}
%{?_enable_geocode:BuildRequires: libgeocode-glib-devel >= %geocode_ver}
%{?_enable_gudev:BuildRequires: libgudev-devel}
%{?_with_cheese:BuildRequires: libcheese-devel}
BuildRequires: libcheck-devel gsettings-desktop-schemas-devel xsltproc
BuildRequires: yelp-tools itstool
BuildRequires: libpulseaudio-devel gstreamer%gst_api_ver-devel gst-plugins%gst_api_ver-devel
BuildRequires: db2latex-xsl evolution-data-server-devel gtk-doc
BuildRequires: xorg-cf-files libICE-devel libSM-devel
BuildRequires: libsoup-devel >= %soup_ver
# for check
BuildRequires: xvfb-run

%description
Telepathy-based multi-protocol instant messaging client for GNOME
which supports Jabber, GTalk, MSN, IRC, Salut, and other protocols.

%package data
Summary: Arch independent files for Empathy
Group: Networking/Instant messaging
BuildArch: noarch

%description data
This package provides noarch data needed for Empathy to work.

%prep
%setup

rm -f data/%name.desktop

%build
NOCONFIGURE=1 ./autogen.sh
%configure \
	--disable-schemas-compile \
	%{subst_enable static} \
	%{?_enable_goa:--enable-goa=yes} \
	%{?_enable_geocode:--enable-geocode=yes} \
	%{?_enable_location:--enable-location=yes} \
	%{?_enable_gudev:--enable-gudev=yes} \
	%{subst_with cheese} \
	--disable-Werror
# SMP-incompatible build
%make

%install
%makeinstall_std

%find_lang --with-gnome --output=%name.lang %name %name-tpaw

%check
# empathy-parser-test failed
# xvfb-run %make check

%files
%_bindir/*
%_libexecdir/empathy-auth-client
%_libexecdir/empathy-call
%dir %_libdir/%name
%_libdir/%name/lib%name-%{version}*.so
%_libdir/%name/lib%name.so
%_libdir/%name/lib%name-gtk-%{version}*.so
%_libdir/%name/lib%name-gtk.so
%exclude %_libdir/%name/*.la
%if_enabled goa
%mcp_dir/mcp-account-manager-goa.so
%exclude %mcp_dir/mcp-account-manager-goa.la
%endif

%files data -f %name.lang
%_datadir/applications/%xdg_name.desktop
%_datadir/dbus-1/services/org.freedesktop.Telepathy.Client.Empathy.Chat.service
%_datadir/dbus-1/services/org.freedesktop.Telepathy.Client.Empathy.Call.service
%_datadir/dbus-1/services/org.freedesktop.Telepathy.Client.Empathy.Auth.service
%_datadir/dbus-1/services/org.freedesktop.Telepathy.Client.Empathy.FileTransfer.service
%dir %_datadir/%name
%_datadir/%name/*.ui
%_datadir/%name/irc-networks.xml
%_datadir/%name/Template.html
%_datadir/%name/%name.css
%_datadir/telepathy/clients/Empathy.Chat.client
%_datadir/telepathy/clients/Empathy.Call.client
%_datadir/telepathy/clients/Empathy.Auth.client
%_datadir/telepathy/clients/Empathy.FileTransfer.client
%_datadir/%name/icons/
%_datadir/%name/%name-log-window.html
%_datadir/icons/hicolor/*/apps/*
%dir %_datadir/adium
%_datadir/adium/*
%_man1dir/*
%config %_datadir/glib-2.0/schemas/*
%_datadir/GConf/gsettings/%name.convert
%_datadir/metainfo/%xdg_name.appdata.xml
%doc AUTHORS CONTRIBUTORS NEWS README TODO


%changelog
