%define _name eog
%define ver_major 3.26
%define api_ver 3.0
%def_enable map
%def_enable postasa

Name: %_name-plugins
Version: %ver_major.3
Release: alt1

Summary: EOG plugins
License: %gpl2plus
Group: Graphics
Url: https://wiki.gnome.org/Apps/EyeOfGnome
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

Requires: eog >= %ver_major libpeas-python3-loader

# use python3
AutoReqProv: nopython
%define __python %nil
%add_python3_path %_libdir/%_name/plugins
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
Requires: libpeas-python3-loader

%define libchamplain_ver 0.12
%define gdata_ver 0.6.0

BuildRequires(pre): rpm-build-licenses rpm-build-gnome rpm-build-gir
BuildPreReq: eog-devel >= %ver_major
BuildRequires: libpeas-devel libgnome-desktop3-devel
%{?_enable_map:BuildRequires: libchamplain-gtk3-devel >= %libchamplain_ver}
%{?_enable_postasa:BuildRequires: libgdata-devel >= %gdata_ver}
BuildRequires: libexempi-devel zlib-devel libjpeg-devel liblcms-devel
BuildRequires: libdbus-glib-devel libxml2-devel librsvg-devel libexif-devel
BuildRequires: gsettings-desktop-schemas-devel gnome-icon-theme

%description
This package provides plugins for the Eye of GNOME, an image viewer program.

%package -n %_name-plugins-postr
Summary: Flickr uploader for EOG
Group: Graphics
Requires: %name = %version-%release
Requires: postr

%description -n %_name-plugins-postr
This package provides Eog plugin for upload pictures to Flickr.

%package -n %_name-plugins-postasa
Summary: Picasa uploader for EOG
Group: Graphics
Requires: %name = %version-%release

%description -n %_name-plugins-postasa
This package provides Eog plugin for upload pictures to Picasa web albums.

%prep
%setup

%build
%autoreconf
export ac_cv_path_POSTR=%_bindir/postr
%configure
#    --disable-schemas-compile

%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%files -f %name.lang
%_libdir/%_name/plugins/*
%_datadir/%_name/plugins/*
%_datadir/appdata/%_name-*.metainfo.xml
%if_enabled postasa
%exclude %_libdir/%_name/plugins/postasa.plugin
%exclude %_libdir/%_name/plugins/libpostasa.so
%exclude %_datadir/appdata/%_name-postasa.metainfo.xml
%endif
%exclude %_libdir/%_name/plugins/libpostr.so
%exclude %_datadir/appdata/%_name-postr.metainfo.xml
%config %_datadir/glib-2.0/schemas/org.gnome.%_name.plugins.exif-display.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.%_name.plugins.fullscreenbg.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.%_name.plugins.pythonconsole.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.%_name.plugins.export-to-folder.gschema.xml
%doc AUTHORS NEWS README

%files -n %_name-plugins-postr
%_libdir/%_name/plugins/libpostr.so
%_datadir/appdata/%_name-postr.metainfo.xml

%if_enabled postasa
%files -n %_name-plugins-postasa
%_libdir/%_name/plugins/postasa.plugin
%_libdir/%_name/plugins/libpostasa.so
%_datadir/appdata/%_name-postasa.metainfo.xml
%endif

%exclude %_libdir/%_name/plugins/*.la

%changelog
