%define soversion 2

Name: faad
Version: 2.10.0
Release: alt1

Summary: FAAD is a Freeware Advanced Audio Decoder
License: GPL-2.0-or-later
Group: Sound

Url: http://www.audiocoding.com
# https://github.com/knik0/faad2/releases
Source: faad2-%version.tar

%define libsndfile_ver 1.0.5

BuildRequires(pre): libsndfile >= %libsndfile_ver

BuildRequires: gcc-c++ id3lib-devel libstdc++-devel zlib-devel

%description
FAAD is a LC, MAIN and LTP profile MPEG2 and MPEG-4 AAC decoder.

%package -n lib%name%soversion
Summary: Freeware Advanced Audio Decoder (FAAD) libraries
Group: System/Libraries
Provides: lib%name = %version-%release

%description -n lib%name%soversion
This package contains Freeware Advanced Audio Decoder (FAAD) shared
libraries.

%package -n lib%name-devel
Summary: Development files for the FAAD AAC decoder libraries
Group: Development/C++
Requires: lib%name%soversion = %version-%release
Requires: libsndfile-devel >= %libsndfile_ver

%description -n lib%name-devel
This package provides header files development libraries and
documentation for lib%name.

%prep
%setup -n faad2-%version

find ./ -type f -name "Makefile*" -print0 | \
xargs -r0 subst 's,^\(CFLAGS\),AM_\1,g
		    s,^\(LDFLAGS\),AM_\1,g
		    s,^[[:blank:]*],\t,' --

%build
%add_optflags %optflags_shared
#_buildshell ./bootstrap
%autoreconf
%configure \
	--disable-static \
	--without-drm \
	#

%make_build

%install
%makeinstall_std

# remove non-packaged files
rm -f %buildroot%_libdir/*.la

%files
%_bindir/*
%_man1dir/*

%files -n lib%name%soversion
%_libdir/*.so.%{soversion}*
%doc AUTHORS ChangeLog NEWS README TODO

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/faad2.pc

%changelog
