%define rname firefox
%set_verify_elf_method relaxed

%define firefox_cid     \{ec8030f7-c20a-464f-9b0e-13a3a9e97384\}
%define firefox_prefix  %_libdir/firefox

%define gst_version   1.0
%define nspr_version  4.33
%define nss_version   3.72
%define rust_version  1.60.0
%define cargo_version 1.60.0
%define llvm_version  11.0

Summary: The Mozilla Firefox project is a redesign of Mozilla's browser (ESR version)
Summary(ru_RU.UTF-8): Интернет-браузер Mozilla Firefox (версия ESR)

Name: firefox-esr
Version: 102.11.0
Release: alt0.c9.1
License: MPL-2.0
Group: Networking/WWW
URL: http://www.mozilla.org/projects/firefox/

Packager: Andrey Cherepanov <cas@altlinux.ru>

Source0: firefox-source.tar
Source1: rpm-build.tar
Source2: searchplugins.tar
Source3: cbindgen-vendor.tar
Source4: firefox-mozconfig
Source5: distribution.ini
Source6: firefox.desktop
Source7: firefox-wayland.desktop
Source8: firefox.c
Source9: firefox-prefs.js
Source10: firefox-l10n.txt
Source11: l10n.tar
Source12: firefox-privacy-prefs.js
Source13: firefox-disable-telemetry-prefs.js
Source14: policies.json

### Start Patches
Patch001: 0001-FEDORA-build-arm-libopus.patch
Patch002: 0002-FEDORA-build-arm.patch
Patch003: 0003-ALT-Fix-aarch64-build.patch
Patch004: 0004-MOZILLA-1196777-GTK3-keyboard-input-focus-sticks-on-.patch
Patch005: 0005-MOZILLA-1170092-Search-for-default-preferences-in-et.patch
Patch006: 0006-use-floats-for-audio-on-arm-too.patch
Patch007: 0007-bmo-847568-Support-system-harfbuzz.patch
Patch008: 0008-bmo-847568-Support-system-graphite2.patch
Patch010: 0009-bmo-1559213-Support-system-av1.patch
Patch011: 0010-Revert-Bug-1712947-Don-t-pass-neon-flags-to-rustc-wh.patch
Patch012: 0011-ALT-fix-double_t-redefinition.patch
Patch013: 0012-build-Disable-Werror.patch
Patch014: 0013-ALT-fix-double-null.patch
### End Patches

# Hang up on build browser/components/about
#ExcludeArch: ppc64le

BuildRequires(pre): mozilla-common-devel
BuildRequires(pre): rpm-build-mozilla.org
BuildRequires(pre): browser-plugins-npapi-devel

BuildRequires: clang%llvm_version
BuildRequires: clang%llvm_version-devel
BuildRequires: llvm%llvm_version-devel
BuildRequires: lld%llvm_version-devel
%ifarch armh %{ix86}
BuildRequires: gcc
BuildRequires: gcc-c++
%endif
BuildRequires: libstdc++-devel
BuildRequires: rpm-macros-alternatives
BuildRequires: rust >= %rust_version
BuildRequires: rust-cargo >= %cargo_version
BuildRequires: libXt-devel libX11-devel libXext-devel libXft-devel libXScrnSaver-devel
BuildRequires: libXcursor-devel
BuildRequires: libXi-devel
BuildRequires: libXcomposite-devel
BuildRequires: libXdamage-devel
BuildRequires: libcurl-devel libgtk+2-devel libgtk+3-devel libhunspell-devel libjpeg-devel
BuildRequires: xorg-cf-files chrpath alternatives yasm
BuildRequires: zip unzip
BuildRequires: bzlib-devel zlib-devel
BuildRequires: libcairo-devel libpixman-devel
BuildRequires: libGL-devel
BuildRequires: libwireless-devel
BuildRequires: libalsa-devel
BuildRequires: libnotify-devel
BuildRequires: libevent-devel
BuildRequires: libproxy-devel
BuildRequires: libshell
BuildRequires: libvpx-devel
BuildRequires: libgio-devel
BuildRequires: libfreetype-devel fontconfig-devel
BuildRequires: libstartup-notification-devel
BuildRequires: libffi-devel
BuildRequires: gstreamer%gst_version-devel gst-plugins%gst_version-devel
BuildRequires: libopus-devel
BuildRequires: libpulseaudio-devel
#BuildRequires: libicu-devel
BuildRequires: libdbus-devel libdbus-glib-devel
BuildRequires: node
BuildRequires: nasm
BuildRequires: libxkbcommon-devel
BuildRequires: libdrm-devel
# 91.0
BuildRequires: libaom-devel
BuildRequires: libdav1d-devel

BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(aom)
BuildRequires: pkgconfig(bzip2)
BuildRequires: pkgconfig(cairo)
BuildRequires: pkgconfig(dav1d)
BuildRequires: pkgconfig(dbus-1)
BuildRequires: pkgconfig(dbus-glib-1)
BuildRequires: pkgconfig(dri)
BuildRequires: pkgconfig(fontconfig)
BuildRequires: pkgconfig(freetype2)
BuildRequires: pkgconfig(gio-2.0)
BuildRequires: pkgconfig(graphite2)
BuildRequires: pkgconfig(gtk+-2.0)
BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(harfbuzz)
BuildRequires: pkgconfig(hunspell)
BuildRequires: pkgconfig(icu-i18n)
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(libdrm)
BuildRequires: pkgconfig(libevent)
BuildRequires: pkgconfig(libffi)
BuildRequires: pkgconfig(libjpeg)
BuildRequires: pkgconfig(libnotify)
BuildRequires: pkgconfig(libproxy-1.0)
BuildRequires: pkgconfig(libpulse)
BuildRequires: pkgconfig(libstartup-notification-1.0)
BuildRequires: pkgconfig(opus)
BuildRequires: pkgconfig(pixman-1)
BuildRequires: pkgconfig(vpx)
BuildRequires: pkgconfig(x11)
BuildRequires: pkgconfig(xcomposite)
BuildRequires: pkgconfig(xcursor)
BuildRequires: pkgconfig(xdamage)
BuildRequires: pkgconfig(xext)
BuildRequires: pkgconfig(xft)
BuildRequires: pkgconfig(xi)
BuildRequires: pkgconfig(xkbcommon)
BuildRequires: pkgconfig(xrandr)
BuildRequires: pkgconfig(xscrnsaver)
BuildRequires: pkgconfig(xt)
BuildRequires: pkgconfig(xtst)
BuildRequires: pkgconfig(zlib)

# Python requires
BuildRequires: /dev/shm

BuildRequires: python-module-setuptools
BuildRequires: python-modules-compiler
BuildRequires: python-modules-logging
BuildRequires: python-modules-sqlite3
BuildRequires: python-modules-json

BuildRequires: python3-base
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-pip
BuildRequires: python3-modules-sqlite3

# Rust requires
BuildRequires: /proc

# Mozilla requires
BuildRequires: pkgconfig(nspr) >= %nspr_version
BuildRequires: pkgconfig(nss) >= %nss_version
BuildRequires: libnss-devel-static

BuildRequires: autoconf_2.13
%set_autoconf_version 2.13

Provides: webclient
Requires: mozilla-common

# ALT#30732
Requires: gst-plugins-ugly%gst_version

Requires: libnspr >= %nspr_version
Requires: libnss >= %nss_version

Conflicts:  firefox

# Localization languages
%define langlist kk ru uk
%{expand:%(for lang in %{langlist}; do echo -e "Provides: firefox-esr-$lang = %%EVR\nObsoletes: firefox-esr-$lang < %%EVR"; done)}

%description
The Mozilla Firefox project is a redesign of Mozilla's browser component,
written using the XUL user interface language and designed to be
cross-platform.

%description -l ru_RU.UTF-8
Интернет-браузер Mozilla Firefox - кроссплатформенная модификация браузера
Mozilla, созданная с использованием языка XUL для описания интерфейса
пользователя.

%package wayland
Summary:    Firefox Wayland launcher.
Group:      Networking/WWW
Requires: %name >= %version-%release
Conflicts:  firefox-wayland

%description wayland
The firefox-wayland package contains launcher and desktop file
to run Firefox natively on Wayland.

%package config-privacy
Summary:    Firefox configuration with the paranoid privacy settings
Group:	    System/Configuration/Networking
BuildArch:  noarch
Requires: %name = %version-%release
Conflicts:  firefox-config-privacy

%description config-privacy
Settings disable:
* obsolete ssl protocols;
* safebrowsing, trackingprotection and other requests to third-party services;
* telemetry;
* webrtc;
* the social features;
* dns and network predictors/prefetch;
* and some more...

Most likely you don't need to use this package.

%prep
%setup -q -n firefox-%version -c

### Begin to apply patches
%autopatch -p1
### Finish apply patches

cd mozilla

tar -xf %SOURCE1
tar -xf %SOURCE2
tar -xf %SOURCE11

cp -f %SOURCE4 .mozconfig

cat >> .mozconfig <<'EOF'
ac_add_options --prefix="%_prefix"
ac_add_options --libdir="%_libdir"
%ifnarch %{ix86} ppc64le
ac_add_options --enable-linker=lld
%ifnarch armh
ac_add_options --enable-lto=thin
%endif
%endif
%ifarch armh ppc64le
ac_add_options --disable-webrtc
%endif
%ifarch armh %{ix86} x86_64
ac_add_options --disable-elf-hack
%endif
%ifarch %{ix86}
ac_add_options --disable-av1
%endif
%ifarch armh %{ix86}
ac_add_options --enable-strip
ac_add_options --enable-install-strip
ac_add_options --disable-rust-debug
ac_add_options --disable-debug-symbols
%endif
EOF

# Begin change checksum for rust checksum file
sed -i 's|73114a5c28472e77082ad259113ffafb418ed602c1741f26da3e10278b0bf93e|a1c64a4b7e6205c6275c3ee47dfb58494e76be7aff9684765ee17d3d469f1681|' ./third_party/rust/mp4parse/.cargo-checksum.json
sed -i 's|75fe5467109242b2cc7991f8228e2e2ad1de5be2f29272a4a7f08c4e21ab5fa4|b6140aa2565ff0b0d1d4b44db97c5cd9a9ecebcc8606791311c770c5dd6fde0a|' ./third_party/rust/mp4parse/.cargo-checksum.json
# Finish change checksum for rust checksum file

find third_party \
	-type f \( -name '*.so' -o -name '*.o' -o -name '*.a' \) \
	-delete

rm -rf -- obj-x86_64-pc-linux-gnu
rm -rf -- third_party/python/setuptools/setuptools*

%build
%add_findprov_lib_path %firefox_prefix

# If MOZ_DEBUG_FLAGS is empty, firefox's build will default it to "-g" which
# overrides the -g0 from line above and breaks building on s390
# (OOM when linking, rhbz#1238225)
export ALTWRAP_LLVM_VERSION="%llvm_version"

export RUST_BACKTRACE=1
%ifarch armh %{ix86}
export RUSTFLAGS="-Clink-args=-fPIC -Cdebuginfo=0"
%else
export RUSTFLAGS="-Clink-args=-fPIC -Cdebuginfo=2"
%endif

# compile cbindgen
CBINDGEN_HOME="$PWD/cbindgen"
CBINDGEN_BINDIR="$CBINDGEN_HOME/bin"

# Do not use desktop notify during build process
export MOZ_NOSPAM=1

if [ ! -x "$CBINDGEN_BINDIR/cbindgen" ]; then
	mkdir -p -- "$CBINDGEN_HOME"

	tar --strip-components=1 -C "$CBINDGEN_HOME" --overwrite -xf %SOURCE3

	cat > "$CBINDGEN_HOME/config" <<-EOF
		[source.crates-io]
		replace-with = "vendored-sources"

		[source.vendored-sources]
		directory = "$CBINDGEN_HOME"
	EOF

	env CARGO_HOME="$CBINDGEN_HOME" \
		cargo install cbindgen
fi

# compile firefox
cd mozilla

%add_optflags %optflags_shared

export MOZ_BUILD_APP=browser

MOZ_OPT_FLAGS="-pipe -O2 -g0"

%ifarch armh
MOZ_OPT_FLAGS="$MOZ_OPT_FLAGS -march=armv7-a -mthumb"
%endif

# PIE, full relro
MOZ_OPT_FLAGS="$MOZ_OPT_FLAGS -DPIC -fPIC -Wl,-z,relro -Wl,-z,now"

# Add fake RPATH
MOZ_OPT_FLAGS="$MOZ_OPT_FLAGS -Wl,-rpath,/$(printf %%s '%firefox_prefix' |tr '[:print:]' '_')"

# If MOZ_DEBUG_FLAGS is empty, firefox's build will default it to "-g" which
# overrides the -g0 from line above and breaks building on s390
# (OOM when linking, rhbz#1238225)
export MOZ_DEBUG_FLAGS=" "

export CFLAGS="$MOZ_OPT_FLAGS"
export CXXFLAGS="$MOZ_OPT_FLAGS"

export MOZ_PARALLEL_BUILD=8
export CC="clang"
export CXX="clang++"
export AR="llvm-ar"
export NM="llvm-nm"
export RANLIB="llvm-ranlib"
export LLVM_PROFDATA="llvm-profdata"
export LIBIDL_CONFIG=/usr/bin/libIDL-config-2
export srcdir="$PWD"
export MOZ_MAKE_FLAGS="-j10 --no-print-directory"
export MOZBUILD_STATE_PATH="$srcdir/mozbuild"
export PATH="$CBINDGEN_BINDIR:$PATH"
export MACH_USE_SYSTEM_PYTHON=1

python3 ./mach python --exec-file /dev/null
python3 ./mach build

while read -r loc; do
	python3 ./mach build chrome-$loc
done < %SOURCE10

make -C objdir/browser/installer multilocale.txt

$CC $CFLAGS \
	-Wall -Wextra \
	-DMOZ_PLUGIN_PATH=\"%browser_plugins_path\" \
	-DMOZ_PROGRAM=\"%firefox_prefix/firefox\" \
	-DMOZ_DIST_BIN=\"%firefox_prefix\"\
	%SOURCE8 -o firefox


%install
cd mozilla

export SHELL=/bin/sh
export MOZ_CHROME_MULTILOCALE="$(tr '\n' ' ' < %SOURCE10)"

mkdir -p \
	%buildroot/%mozilla_arch_extdir/%firefox_cid \
	%buildroot/%mozilla_noarch_extdir/%firefox_cid \
	#

make -C objdir \
	DESTDIR=%buildroot \
	INSTALL="/bin/install -p" \
	mozappdir=%firefox_prefix \
	libdir=%_libdir \
	install

# install altlinux-specific configuration
install -D -m 644 %SOURCE9  %buildroot/%firefox_prefix/browser/defaults/preferences/all-altlinux.js
install -D -m 644 %SOURCE12 %buildroot/%_sysconfdir/firefox/pref/all-privacy.js
install -D -m 644 %SOURCE13 %buildroot/%_sysconfdir/firefox/pref/disable-telemetry-prefs.js

# Install default policies
install -D -m 644 %SOURCE14 %buildroot%_sysconfdir/firefox/policies/policies.json

cat > %buildroot/%firefox_prefix/browser/defaults/preferences/firefox-l10n.js <<EOF
pref("intl.locale.matchOS", true);
pref("intl.locale.requested", "");
pref("general.useragent.locale", "chrome://global/locale/intl.properties");
EOF

# icons
for s in 16 22 24 32 48 256; do
	install -D -m 644 \
		browser/branding/official/default$s.png \
		%buildroot/%_iconsdir/hicolor/${s}x${s}/apps/firefox.png
done

# ALT#30572
if [ ! -e "%buildroot/%firefox_prefix/plugins" ]; then
	what="$(relative %browser_plugins_path %firefox_prefix/plugins)"
	ln -s -- "$what" %buildroot/%firefox_prefix/plugins
fi

install -m755 firefox %buildroot/%_bindir/firefox

cd %buildroot

# Wrapper for wayland
cat > ./%_bindir/firefox-wayland <<'EOF'
#!/bin/sh
export GDK_BACKEND=wayland
export MOZ_ENABLE_WAYLAND=1
export MOZ_GTK_TITLEBAR_DECORATION=client
export XDG_SESSION_TYPE=wayland

unset DISPLAY

exec %_bindir/firefox "$@"
EOF

chmod +x ./%_bindir/firefox-wayland

# Add distribution.ini
mkdir -p -- ./%firefox_prefix/distribution
cp -- %SOURCE5 ./%firefox_prefix/distribution/distribution.ini

# install menu file
install -D -m 644 %SOURCE6 ./%_datadir/applications/firefox.desktop
install -D -m 644 %SOURCE7 ./%_datadir/applications/firefox-wayland.desktop

# Add alternatives
mkdir -p ./%_altdir
printf '%_bindir/xbrowser\t%_bindir/firefox\t80\n' >./%_altdir/firefox-esr

rm -f -- \
	./%firefox_prefix/removed-files

# Remove devel files
rm -rf -- \
	./%_includedir/%rname \
	./%_datadir/idl/%rname \
	./%_libdir/%rname-devel \
#

# Add real RPATH
(set +x
	rpath="/$(printf %%s '%firefox_prefix' |tr '[:print:]' '_')"
	find %buildroot -type f |
	while read f; do
		t="$(readlink -ev "$f")"
		file "$t" | fgrep -qs ELF ||
			continue
		chrpath -l "$t" |
			fgrep -qs \
				-e "RPATH=$rpath" \
				-e "RUNPATH=$rpath" ||
			continue
		chrpath -r "%firefox_prefix" "$t"
	done
)

%files
%dir %_sysconfdir/firefox
%dir %_sysconfdir/firefox/pref
%config(noreplace) %_sysconfdir/firefox/pref/disable-telemetry-prefs.js
%dir %_sysconfdir/firefox/policies
%config(noreplace) %_sysconfdir/firefox/policies/policies.json
%_altdir/firefox-esr
%_bindir/firefox
%firefox_prefix
%mozilla_arch_extdir/%firefox_cid
%mozilla_noarch_extdir/%firefox_cid
%_datadir/applications/firefox.desktop
%_iconsdir/hicolor/16x16/apps/firefox.png
%_iconsdir/hicolor/22x22/apps/firefox.png
%_iconsdir/hicolor/24x24/apps/firefox.png
%_iconsdir/hicolor/32x32/apps/firefox.png
%_iconsdir/hicolor/48x48/apps/firefox.png
%_iconsdir/hicolor/256x256/apps/firefox.png

%files wayland
%_bindir/firefox-wayland
%_datadir/applications/firefox-wayland.desktop

%files config-privacy
%config(noreplace) %_sysconfdir/firefox/pref/all-privacy.js

%changelog
