# -*- coding: utf-8; mode: rpm-spec -*-
# $Id: fonts-bitmap-terminus.spec,v 1.5 2006/05/05 08:01:35 eugene Exp $

%define cname terminus
%define fontsdir %_datadir/fonts/bitmap/terminus
%define cfontsdir /lib/kbd/consolefonts

Name: fonts-bitmap-%cname
Version: 4.47
Release: alt1
Summary: Terminus Font - a clean fixed width font
Summary(ru_RU.UTF-8): Шрифт Terminus - растровый моноширинный шрифт
License: OFL
Group: System/Fonts/X11 bitmap
URL: http://sourceforge.net/projects/terminus-font/
BuildArch: noarch

Packager: Eugene Vlasov <eugvv@altlinux.ru>

Source0: %cname-font-%version.tar.gz
Source1: %cname-FAQ
Source2: ibm-866.uni

Patch0: %cname-4.40-alt-12pt_ve_fix.patch
Patch1: %cname-4.40-alt-be2.patch
Patch2: %cname-4.47-alt-cp866.patch

Provides: terminus-font = %version-%release

Obsoletes: %cname-fonts-bitmap < %version
Provides: %cname-fonts-bitmap = %version-%release

BuildPreReq: fontconfig python3 xorg-font-utils

%description
Terminus Font is designed for long (8 and more hours per day) work with
computers. Version 4.38 contains 879 characters, covers about 120 language
sets and supports ISO8859-1/2/5/9/13/15/16, Paratype-PT154/PT254, KOI8-R/U/E/F,
Esperanto many IBM, Windows and Macintosh code pages, as well as the IBM VGA,
vt100 and xterm pseudographic characters.
The sizes present are 6x12, 8x14, 8x16, 10x20, 11x22, 12x24, 14x28 and 16x32.
The styles are normal and bold (except for 6x12), plus EGA/VGA-bold for
8x14 and 8x16.
This package contains Terminus Font for X Window System.

%description -l ru_RU.UTF-8
Шрифт Terminus разработан для длительной (8 часов и более) работы с
компьютером. Версия 4.38 содержит 879 символов, полностью охватывая
около 120 языковых наборов и поддерживая ISO8859-1/2/5/9/13/15/16,
Paratype-PT154/PT254, KOI8-R/U/E/F, Esperanto, многие кодовые страницы IBM,
Windows и Macintosh. Также включены псевдографические символы IBM VGA, vt100 и
xterm.
Представлены размеры 6x12, 8x14, 8x16, 10x20, 11x22, 12x24, 14x28 и 16x32,
обычный и жирный шрифт (для размера 6x12 - только обычный), и жирный
шрифт для EGA/VGA размером 8x14 и 8x16.
Этот пакет содержит шрифт Terminus для X Window.


%package -n fonts-console-%cname
Summary: Terminus Font - a clean font for console
Summary(ru_RU.UTF-8): Шрифт Terminus для консоли
Group: System/Fonts/Console

Obsoletes: %cname-fonts-console <= 4.14-alt1
Provides: %cname-fonts-console = %version-%release

%description -n fonts-console-%cname
Terminus Font is designed for long (8 and more hours per day) work with
computers. Version 4.38 contains 879 characters, covers about 120 language
sets and supports ISO8859-1/2/5/9/13/15/16, Paratype-PT154/PT254, KOI8-R/U/E/F,
Esperanto many IBM, Windows and Macintosh code pages, as well as the IBM VGA,
vt100 and xterm pseudographic characters.
The sizes present are 6x12, 8x14, 8x16, 10x20, 11x22, 12x24, 14x28 and 16x32.
The styles are normal and bold (except for 6x12), plus EGA/VGA-bold for
8x14 and 8x16.
This package contains Terminus Font for Linux console.

%description -l ru_RU.UTF-8 -n fonts-console-%cname
Шрифт Terminus разработан для длительной (8 часов и более) работы с
компьютером. Версия 4.38 содержит 879 символов, полностью охватывая
около 120 языковых наборов и поддерживая ISO8859-1/2/5/9/13/15/16,
Paratype-PT154/PT254, KOI8-R/U/E/F, Esperanto, многие кодовые страницы IBM,
Windows и Macintosh. Также включены псевдографические символы IBM VGA, vt100 и
xterm.
Представлены размеры 6x12, 8x14, 8x16, 10x20, 11x22, 12x24, 14x28 и 16x32,
обычный и жирный шрифт (для размера 6x12 - только обычный), и жирный
шрифт для EGA/VGA размером 8x14 и 8x16.
Этот пакет содержит шрифт Terminus для консоли Linux.

%prep
%setup -n %cname-font-%version
#%%patch0 -p2
%patch1 -p2
%patch2 -p2
cp %SOURCE2 uni/
touch dup/ibm-866.dup

%build
patch < alt/dv1.diff
patch < alt/gq2.diff
patch < alt/ll2.diff
patch < alt/td1.diff
patch < alt/ij1.diff
chmod +x configure
./configure --prefix=%_prefix \
    --psfdir=%cfontsdir \
    --x11dir=%fontsdir
export GZIP=--best
%make_build

%install
cp %SOURCE1 FAQ
%makeinstall_std fontdir

mkdir -p %buildroot%_sysconfdir/X11/fontpath.d
ln -s ../../..%fontsdir %buildroot%_sysconfdir/X11/fontpath.d/bitmap-terminus:unscaled:pri=20

%triggerun -- %name < 4.20-alt2.1
if [ -x %_sbindir/chkfontpath -a -f %_sysconfdir/X11/fs/config ]; then
    %_sbindir/chkfontpath -q -r %fontsdir ||:
fi

%files
%doc CHANGES README FAQ OFL.TXT
%_sysconfdir/X11/fontpath.d/*
%fontsdir

%files -n fonts-console-%cname
%doc CHANGES README FAQ OFL.TXT
%cfontsdir/*.psf.gz

%changelog
