%define _unpackaged_files_terminate_build 1

Name: fprintd
Version: 1.90.9
Release: alt1
Summary: D-Bus service for Fingerprint reader access
Group: System/Servers
Url: https://www.freedesktop.org/wiki/Software/fprint/fprintd
License: GPLv2+

# https://gitlab.freedesktop.org/libfprint/fprintd
Source: %name-%version.tar
Source1: system-auth-fprintd

Patch: %name-%version.patch

BuildRequires(pre): meson
BuildRequires: libdbus-glib-devel
BuildRequires: pkgconfig(libfprint-2) > 0.1.0
BuildRequires: libfprint2-gir-devel
BuildRequires: pkgconfig(glib-2.0) pkgconfig(dbus-glib-1)
BuildRequires: pkgconfig(gmodule-2.0) pkgconfig(polkit-gobject-1) >= 0.91 pkgconfig(gio-2.0) >= 2.26
BuildRequires: libpam0-devel
BuildRequires: gtk-doc intltool
BuildRequires: /usr/bin/pod2man /usr/bin/xmllint /usr/bin/xsltproc docbook-dtds
BuildRequires: pkgconfig(systemd)
BuildRequires: pkgconfig(libpamtest)
BuildRequires: python3-module-pycairo
BuildRequires: python3-module-dbus
BuildRequires: python3-module-dbusmock
BuildRequires: python3-module-libpamtest
BuildRequires: python3(gi)

%description
D-Bus service to access fingerprint readers.

%package -n pam_fprintd
Summary: PAM module for fingerprint authentication
Provides: pam_fprint
Obsoletes: pam_fprint <= 0.2
Group: System/Base

%description -n pam_fprintd
PAM module that uses the fprintd D-Bus service for fingerprint
authentication.

%package devel
Summary: Development files for %name
Requires: %name = %EVR
Group: Development/Other
BuildArch: noarch

%description devel
Development documentation for fprintd, the D-Bus service for
fingerprint readers access.

%prep
%setup -q
%patch -p1

%build
%meson
%meson_build

%install
%meson_install
%find_lang %name

%check
%meson_test

%files -f %name.lang
%doc README COPYING AUTHORS TODO
%config(noreplace) %_sysconfdir/fprintd.conf
#_sysconfdir/pam.d/system-auth-fprintd
%_datadir/dbus-1/system.d/net.reactivated.Fprint.conf
%_bindir/fprintd-*
%_prefix/lib/fprintd
%_unitdir/fprintd.service
%_datadir/dbus-1/system-services/net.reactivated.Fprint.service
%_datadir/polkit-1/actions/net.reactivated.fprint.device.policy
%_man1dir/fprintd.1*

%files -n pam_fprintd
%doc pam/README
/%_lib/security/pam_fprintd.so
%_man8dir/pam_fprintd.8*

%files devel
#_datadir/gtk-doc/html/fprintd
%_datadir/dbus-1/interfaces/net.reactivated.Fprint.Device.xml
%_datadir/dbus-1/interfaces/net.reactivated.Fprint.Manager.xml

%changelog
