Name:		freebasic
Version:	1.07.3
Release:	alt1

Summary:	FreeBASIC language compiler
License:	GPL-2.0+ and LGPL-2.0+ with exception and GFDL-1.1-or-later
Group:		Education

ExclusiveArch: %ix86 x86_64

Source:		FreeBASIC-%version-source.tar
Source1:	FB-manual-%version-html.zip
URL: 		http://freebasic.net
#VCS:           https://github.com/freebasic/fbc

Provides:	FreeBASIC = %version-%release

BuildRequires:  freebasic
BuildRequires:  gcc-c++
BuildRequires:  libffi-devel
BuildRequires:  libgpm-devel
BuildRequires:  libGL-devel
BuildRequires:  libncurses-devel
BuildRequires:  libX11-devel
BuildRequires:  libXext-devel
BuildRequires:  libXpm-devel
BuildRequires:  libXrandr-devel
BuildRequires:  zlib-devel
BuildRequires:  unzip

Requires: 	gcc

%description	
FreeBASIC - is a completely free, open-source, 32-bit BASIC compiler,
with syntax similar to MS-QuickBASIC, that adds new features such as
pointers, unsigned data types, inline assembly, object orientation,
and many others.

%prep
%setup -q -n FreeBASIC-%version-source
mkdir doc/html
unzip -q %SOURCE1 -d doc/html
ln -s 00index.html doc/html/index.html

%build
%make_build FBCFLAGS="-i /usr/include/freebasic" FBLFLAGS="-p %_libdir/freebasic -prefix %_prefix"

%install
%makeinstall_std prefix=%_prefix

# Install man page
install -D doc/fbc.1 %buildroot%_man1dir/fbc.1

# Install examples
mkdir -p %buildroot%_datadir/freebasic
cp -a examples %buildroot%_datadir/freebasic

# Install manual
mkdir -p %buildroot%_docdir/freebasic
cp -a doc/html/* %buildroot%_docdir/freebasic

%check
#make -C tests log-tests FB_LANG=fb || /bin/true

%files
%doc *.txt
%_bindir/fbc
%_includedir/freebasic/
%_libexecdir/freebasic/
%_datadir/freebasic/
%doc %_docdir/freebasic
%_man1dir/*

%changelog
