Epoch: 0
Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-java
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Prevent brp-java-repack-jars from being run.
%global __jar_repack %{nil}

Name:           freemarker
Version:        2.3.27
Release:        alt1_2jpp8
Summary:        The Apache FreeMarker Template Engine
License:        ASL 2.0
URL:            https://freemarker.apache.org/
Source0:        https://github.com/apache/incubator-freemarker/archive/v%{version}/%{name}-%{version}.tar.gz

# Remove JSP 2.0 API usage
Patch1:         jsp-api.patch
# Compile only the classes compatible with the version of jython
Patch2:         jython-compatibility.patch
# illegal character in the javadoc comment
Patch3:         fix-javadoc-encoding.patch
# Disable JRebel integration, it is not free software and not in Fedora
Patch5:         no-javarebel.patch
# enable jdom extension
Patch6:         enable-jdom.patch
# Fix compatibility with javacc 7
Patch7:         javacc-7.patch

BuildArch:      noarch

BuildRequires: ant
BuildRequires: apache-parent
BuildRequires: apache-commons-logging
BuildRequires: aqute-bnd
BuildRequires: avalon-logkit >= 1.2
BuildRequires: dom4j >= 1.6.1
BuildRequires: hamcrest
BuildRequires: ivy-local
BuildRequires: glassfish-jsp-api
BuildRequires: glassfish-servlet-api
BuildRequires: javacc >= 7.0
BuildRequires: jaxen >= 1.1
BuildRequires: jcl-over-slf4j
BuildRequires: jdom >= 1.0
BuildRequires: junit
BuildRequires: jython
BuildRequires: log4j-over-slf4j
BuildRequires: rhino >= 1.6
BuildRequires: saxpath
BuildRequires: slf4j
BuildRequires: xalan-j2 >= 2.7.0
Source44: import.info

%description
Apache FreeMarker is a template engine: a Java library to generate text output
(HTML web pages, e-mails, configuration files, source code, etc.) based on
templates and changing data. Templates are written in the FreeMarker Template
Language (FTL), which is a simple, specialized language (not a full-blown
programming language like PHP).

%package javadoc
Group: Development/Java
Summary: Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.

%prep
%setup -q -n incubator-freemarker-%{version}

find -type f -name "*.jar" -delete
find -type f -name "*.class" -delete

%patch1
%patch2
%patch3
%patch5
%patch6
%patch7 -p1

# Use system ivy settings
rm ivysettings.xml

# Correct classpath for Javadoc generation
sed -i 's/cachepath conf="IDE"/cachepath conf="javadoc"/' build.xml
sed -i '/conf name="IDE"/i<conf name="javadoc" extends="build.jython2.5,build.jsp2.1" />' ivy.xml

%mvn_file org.%{name}:%{name} %{name}

%build
ant -Divy.mode=local -Ddeps.available=true javacc jar javadoc maven-pom

%install
%mvn_artifact build/pom.xml build/%{name}.jar
%mvn_install -J build/api

%files -f .mfiles
%doc README.md RELEASE-NOTES
%doc --no-dereference LICENSE NOTICE

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE NOTICE

%changelog
