Name: gawk
Version: 4.2.1.0.170.dc189d
Release: alt2

%define _libexecdir %prefix/libexec
# Documentation build requirements are insane.
%def_without doc

Summary: The GNU version of the AWK text processing utility
License: GPLv3+
Group: Text tools
Url: https://www.gnu.org/software/gawk/

# git://git.altlinux.org/gears/g/gawk.git
Source: %name-%version-%release.tar

Provides: awk = %version, dgawk = %version, gawk-profile = %version
Obsoletes: dgawk < %version, gawk-profile < %version

# Automatically added by buildreq on Wed Feb 13 2019
# optimized out: fontconfig fonts-type1-urw ghostscript-classic ghostscript-common glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config groff-base libgpg-error libsasl2-3 perl perl-Encode perl-Text-Unidecode perl-Unicode-EastAsianWidth perl-Unicode-Normalize perl-libintl perl-parent python-base python-modules sh4 tex-common texlive texlive-collection-basic texlive-dist tzdata
BuildRequires: libreadline-devel makeinfo
%{?_with_doc:BuildRequires: ghostscript-utils groff-ps texi2dvi texlive-generic-recommended}
%{?!_without_check:%{?!_disable_check:BuildRequires: /dev/pts}}

%description
This packages contains the GNU version of AWK, a text processing utility.
AWK interprets a special-purpose programming language to do quick
and easy text pattern matching and reformatting jobs.  Gawk should be
upwardly compatible with the Bell Labs research version of AWK and is
almost completely compliant with the 1993 POSIX 1003.2 standard for AWK.

%package doc
Summary: Documentation about the GNU version of the AWK text processing utility
Group: Text tools
BuildArch: noarch
Requires: %name = %version-%release

%description doc
This packages contains documentation about the GNU version of the AWK
text processing utility.

%prep
%setup -n %name-%version-%release

%build
./bootstrap.sh
rm awkgram.c command.c doc/*.info awklib/stamp-eg
%configure --bindir=/bin --without-libsigsegv-prefix
# SMP-incompatible
make awkgram.c command.c
%make_build
%if_with doc
cd doc
%make_build gawk.dvi awkcard.pdf
dvipdf gawk.dvi
cd -
%endif

%install
%makeinstall_std
rm %buildroot/bin/gawk-4.2.1a
mkdir -p %buildroot%_bindir
ln -rs %buildroot/bin/gawk %buildroot%_bindir/
for n in awk dgawk pgawk; do
	ln -s gawk %buildroot%_bindir/$n
	ln -s gawk.1 %buildroot%_man1dir/$n.1
done

%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir
install -pm644 AUTHORS NEWS POSIX.STD README \
	%{?_with_doc:doc/{gawk,awkcard}.pdf} %buildroot%docdir/

%find_lang %name

%check
%make_build -k check

%files -f %name.lang
/bin/*
%_bindir/*
%_datadir/awk/
%_libdir/gawk/
%_libexecdir/awk/
%_includedir/*.h
%_infodir/*.info*
%_mandir/man?/*

%dir %docdir
%docdir/[A-Z]*

%if_with doc
%files doc
%dir %docdir
%docdir/*.pdf
%endif

%changelog
