%def_disable snapshot
%define _libexecdir %_prefix/libexec

# ffmpegthumbnailer code is broken
%def_enable ffmpegthumbnailer

Name: geeqie
Version: 1.5.1
Release: alt1

Summary: Graphics file browser utility
License: GPLv2+
Group: Graphics

Url: http://%name.org
%if_disabled snapshot
Source: %url/%name-%version.tar.xz
%else
# VCS: http://www.geeqie.org/git/geeqie.git
Source: %name-%version.tar
%endif

Patch: %name-1.5-libdir-fix.patch

Provides: gqview = %version-%release
Obsoletes: gqview < %version

BuildRequires: gcc-c++ gnome-doc-utils intltool libgtk+2-devel libjpeg-devel
BuildRequires: liblcms2-devel liblirc-devel libtiff-devel libexiv2-devel
%{?_enable_ffmpegthumbnailer:BuildRequires: libffmpegthumbnailer-devel}
# while gtk+2 is a default
#BuildRequires: libchamplain-gtk3-devel

%description
Geeqie is a lightweight image viewer. It was forked from GQview. The development
is focused on features for photo collection maintenance: raw format, Exif/IPTC/XMP
metadata and integration with programs like UFraw, ImageMagick, Gimp, gPhoto or
ExifTool.

%prep
%setup
%patch -b .libdir
sed -i 's/\-Werror//' configure.ac

%build
#%%add_optflags -Wno-error=unused-variable -Wno-parentheses -Wunused-variable
%{?_enable_ffmpegthumbnailer:%add_optflags -Wno-error=unused-function}
%autoreconf
%configure --enable-lirc \
	--enable-largefile \
	--with-readmedir=%_datadir/%name \
	--disable-lua \
	%{subst_enable ffmpegthumbnailer}
%make_build

%install
%makeinstall_std
install -pD -m644 %name.png %buildroot%_liconsdir/%name.png

%find_lang %name

%files -f %name.lang
%_bindir/%name
%_datadir/%name/
%_libdir/%name/
%_desktopdir/%name.desktop
%_pixmapsdir/%name.png
%_iconsdir/hicolor/*x*/apps/%name.png
%_man1dir/%name.1.*
%doc NEWS README.*

%changelog
