# vim: set ft=spec: -*- rpm-spec -*-
%define        pkgname facter

Name:          gem-%pkgname
Version:       2.5.7.1
Release:       alt1
Summary:       Ruby library for retrieving facts from operating systems
Group:         Development/Ruby
License:       Apache-2.0
Url:           https://tickets.puppetlabs.com/browse/FACT
Vcs:           https://github.com/puppetlabs/facter.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
Patch:         %name-2.5.7-timeout.patch
BuildRequires(pre): rpm-build-ruby
BuildRequires: libcpp-hocon-devel
BuildRequires: libyaml-cpp-devel
BuildRequires: libleatherman-devel
BuildRequires: boost-program_options-devel

Requires:      coreutils
Requires:      dmidecode
Requires:      net-tools
Requires:      pciutils
Requires:      bind-utils
%add_findreq_skiplist *.erb
%add_findreq_skiplist %ruby_gemslibdir/*
Obsoletes:     ruby-%pkgname
Provides:      ruby-%pkgname

%description
A cross-platform Ruby library for retrieving facts from
operating systems. Supports multiple resolution mechanisms, any
of which can be restricted to working only on certain operating
systems or environments. Facter is especially useful for
retrieving things like operating system names, IP addresses, MAC
addresses, and SSH keys.

It is easy to extend Facter to include your own custom facts or
to include additional mechanisms for retrieving facts.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.


%package       -n %pkgname
Summary:       Console executable called 'facter'
Group:         System/Base
BuildArch:     noarch

%description -n %pkgname
%summary, for retrieving facts from
operating systems. Supports multiple resolution mechanisms, any
of which can be restricted to working only on certain operating
systems or environments. Facter is especially useful for
retrieving things like operating system names, IP addresses, MAC
addresses, and SSH keys.


%prep
%setup
%patch -p1
sed -e 's/ALT /ALT/g' -e 's/ALTLinux/ALT/' -i lib/facter/operatingsystem/linux.rb

%build
%ruby_build --ignore=acceptance --use=%gemname --version-replace=%version

%install
%ruby_install

%check
%ruby_test

%files
%ruby_gemspec
%ruby_gemlibdir

%files         doc
%ruby_gemdocdir

%files         -n %pkgname
%_bindir/*
%doc %_man8dir/%{pkgname}.*


%changelog
