%define        pkgname posix-mq
%define        gemname posix_mq

Name:          gem-%pkgname
Version:       2.4.1
Release:       alt3
Summary:       POSIX Message Queues for Ruby
Group:         Development/Ruby
License:       LGPLv3+ and GPLv2
Url:           http://bogomips.org/ruby_posix_mq/
Vcs:           https://bogomips.org/ruby_posix_mq.git

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Obsoletes:     ruby-%gemname < %EVR
Provides:      ruby-%gemname = %EVR

%description
POSIX message queues allow local processes to exchange data in the form
of messages. This API is distinct from that provided by System V
message queues, but provides similar functionality.


%package       -n posix-mq-rb
Summary:       %summary
Group:         Development/Documentation
BuildArch:     noarch

%description   -n posix-mq-rb
%summary.

Executables files for %gemname gem.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README*
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         -n gem-%pkgname-doc
%ruby_gemdocdir

%files         -n posix-mq-rb
%_bindir/posix-mq-rb

%changelog
