%define        pkgname setup

Name:          gem-%pkgname
Version:       5.999.4
Release:       alt3
Summary:       Ruby's Classic Site Installer
Group:         Development/Ruby
License:       BSD-2-Clause
Url:           https://github.com/rubyworks/setup
Vcs:           https://github.com/majioa/setup.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
Patch:         patch.patch

BuildRequires(pre): rpm-build-ruby

Requires:      chrpath
Requires:      setup-rb

%description
Every well practiced Rubyist is aware of Minero Aoki's ever setup.rb script.
It's how most of us used to install our Ruby programs before RubyGems came
along. And it's still mighty useful in certain scenarios, not the least of
which is the job of the distro package maintainer.

Ruby Setup converts setup.rb into a stand-alone application. No longer
requiring the distribution of the setup.rb script with every Ruby package.
Just instruct one's users to install Ruby Setup (gem install setup) and go from
there. As long as a project is setup.rb compliant, as most are, then there is
little to nothing it's developer must do.


%package       -n setup-rb
Summary:       Executable file for %gemname gem
Summary(ru_RU.UTF-8): Исполнямка для самоцвета %gemname
Group:         Development/Ruby
BuildArch:     noarch

%description   -n setup-rb
Executable file for %gemname gem.

%description   -n setup-rb -l ru_RU.UTF8
Исполнямка для %gemname самоцвета.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%prep
%setup
%patch -p1

%build
%__setup_rb build --use=setup --alias=setup-rb

%install
%__setup_rb install --install_prefix=%buildroot

%check
%__setup_rb test

%files
%doc README* HISTORY* MANIFEST
%ruby_gemspec
%ruby_gemlibdir

%files         -n setup-rb
%doc README*
%_bindir/setup.rb

%files         doc
%ruby_gemdocdir


%changelog
