%define        pkgname unicorn

Name:          gem-%pkgname
Version:       5.5.4
Release:       alt1
Summary:       Unicorn: Rack HTTP server for fast clients and Unix
License:       GPLv2+ or Ruby
Group:         System/Servers
Url:           https://unicorn.bogomips.org/
Vcs:           https://bogomips.org/unicorn.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: ragel

%add_findreq_skiplist %ruby_gemslibdir/**/*

%description
Unicorn is an HTTP server for Rack applications designed to only serve
fast clients on low-latency, high-bandwidth connections and take
advantage of features in Unix/Unix-like kernels. Slow clients should
only be served by placing a reverse proxy capable of fully buffering
both the the request and response in between Unicorn and slow clients.


%package       -n %pkgname
Summary:       Executable file for %gemname gem
Group:         Development/Ruby
BuildArch:     noarch

Conflicts:     golang-tools

%description   -n %pkgname
%summary.

Executable file for %gemname gem.

%description   -n %pkgname -l ru_RU.UTF8
Крайне быстрый и простой веб-сервер для Рубина.

Исполнямка для %gemname самоцвета.


%package       devel
Summary:       Development files for %gemname gem
Group:         Development/Ruby
BuildArch:     noarch

Requires:      ragel

%description   devel
Development files for %gemname gem.

%description   devel -l ru_RU.UTF8
Файлы заголовков для самоцвета %gemname.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.



%prep
%setup

%build
%ruby_build

%install
%ruby_install

%files
%doc README*
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         -n %pkgname
%doc README*
%_bindir/%{pkgname}*
%_mandir/%{pkgname}*

%files         doc
%ruby_gemdocdir

%files         devel
%ruby_includedir/*


%changelog
