%def_disable snapshot
%define ver_major 3.32
%define xdg_name org.gnome.Calculator
%define _libexecdir %_prefix/libexec

Name: gnome-calculator
Version: %ver_major.2
Release: alt1

Summary: GTK+3 based desktop calculator
License: %gpl2plus
Group: Sciences/Mathematics
Url: https://wiki.gnome.org/Apps/Calculator

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Obsoletes: gcalctool <= 6.6.2
Provides: gcalctool = 6.6.2

BuildRequires(pre): meson rpm-build-licenses rpm-build-gnome
BuildRequires: vala-tools >= 0.24
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: libgtk+3-devel >= 3.20.0
BuildRequires: libgio-devel >= 2.48.0 libxml2-devel
BuildRequires: libmpfr-devel libgtksourceview4-devel >= 4.0.2
BuildRequires: libsoup-devel >= 2.42 libmpc-devel

%description
This package provides gcalctool, the calculator application that was
previously in the OpenWindows Deskset of the Solaris 8 operating system.

It incorporates a multiple precision arithmetic packages based on the work
of Professor Richard Brent.

A single graphics driver for GTK included with this package.

%prep
%setup
find ./ -name "*.stamp" -delete

%build
%meson
%meson_build

%install
%meson_install

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%_libexecdir/%name-search-provider
%_datadir/dbus-1/services/org.gnome.Calculator.SearchProvider.service
%_datadir/gnome-shell/search-providers/%xdg_name-search-provider.ini
%_desktopdir/%xdg_name.desktop
%_man1dir/%name.1.*
%_man1dir/gcalccmd.1.*
%config %_datadir/glib-2.0/schemas/org.gnome.calculator.gschema.xml
%_iconsdir/hicolor/*/*/%{xdg_name}*.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%doc NEWS


%changelog
