%define _unpackaged_files_terminate_build 1

%define _name chess
%define xdg_name org.gnome.Chess
%define __name gnome-%_name
%define ver_major 3.32
%define _libexecdir %_prefix/libexec

Name: gnome-games-%_name
Version: %ver_major.0
Release: alt1

Summary: A chess game for GNOME
Group: Games/Boards
License: GPLv3+
Url: https://wiki.gnome.org/Apps/Chess

Source: ftp://ftp.gnome.org/pub/gnome/sources/%__name/%ver_major/%__name-%version.tar.xz

Provides:  %__name = %version-%release
Obsoletes: gnome-games-glchess
Provides:  gnome-games-glchess = %version-%release
Requires: gnuchess >= 6.2.3

%define glib_ver 2.40
%define gtk_ver 3.22.0
%define vala_ver 0.22.0

BuildRequires(pre): meson
BuildRequires: vala-tools >= %vala_ver
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver
BuildRequires: librsvg-devel gsettings-desktop-schemas-devel
BuildRequires: libGL-devel libGLU-devel

%description
A chess game which supports several chess engines, with 2D and optionally
3D support if OpenGL is present.

%prep
%setup -n %__name-%version

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %__name

%files -f gnome-%_name.lang
%_bindir/%__name
%_desktopdir/%xdg_name.desktop
%_datadir/%__name
%_iconsdir/hicolor/*/apps/%{xdg_name}*.*
%_man6dir/%__name.*
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%config(noreplace) %_sysconfdir/%__name/engines.conf
%_datadir/metainfo/%xdg_name.appdata.xml

%changelog
