%def_disable snapshot

%define _libexecdir %_prefix/libexec
%define _userunitdir %(pkg-config systemd --variable systemduserunitdir)
%define xdg_name org.gnome.Shell
%define ver_major 3.32
%define gst_api_ver 1.0
%def_enable gtk_doc
%def_disable check
# removed in 3.31.x
%def_disable browser_plugin

Name: gnome-shell
Version: %ver_major.2
Release: alt1

Summary: Window management and application launching for GNOME
Group: Graphical desktop/GNOME
License: GPLv2+
Url: https://wiki.gnome.org/Projects/GnomeShell

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
Patch3: %name-3.8.4-alt-invalid_user_shell.patch

Obsoletes: gnome-shell-extension-per-window-input-source

# use python3
AutoReqProv: nopython
%define __python %nil

%define session_ver 3.26
%define clutter_ver 1.21.5
%define gjs_ver 1.56.0
%define mutter_ver %version
%define gtk_ver 3.16.0
%define gio_ver 2.56.0
%define gstreamer_ver 1.0
%define eds_ver 3.17.2
%define telepathy_ver 0.17.5
%define telepathy_logger_ver 0.2.4
%define polkit_ver 0.100
%define bluetooth_ver 3.11.3
%define folks_ver 0.5.2
%define gi_ver 1.49.1
%define sn_ver 0.11
%define gcr_ver 3.8
%define atspi_ver 2.5.91
%define menus_ver 3.5.3
%define desktop_ver 3.8
%define json_glib_ver 0.13.2
%define nm_ver 1.10.4
%define ibus_ver 1.5.2

Requires: %name-data = %version-%release
Requires: mutter-gnome >= %mutter_ver libmutter-gir >= %mutter_ver
Requires: gnome-session >= %session_ver
Requires: dconf gnome-icon-theme gnome-icon-theme-symbolic
Requires: at-spi2-atk ca-certificates polkit
# since 3.11.x requires org.gnome.login-screen schema
Requires: gdm-data
# gkbd-keyboard-display required to show keyboard layouts
Requires: libgnomekbd
# network.js requires
Requires: gnome-control-center
# since 3.16
Requires: polari
# for OSK
Requires: ibus ibus-gtk3

# find ./ -name "*.js" |/usr/lib/rpm/gir-js.req |sort|uniq|sed -e 's/^/Requires: /'
Requires: typelib(AccountsService)
Requires: typelib(Atk)
Requires: typelib(Atspi)
Requires: typelib(Clutter)
Requires: typelib(Cogl)
Requires: typelib(Gcr)
Requires: typelib(GDesktopEnums)
Requires: typelib(Gdk)
Requires: typelib(GdkPixbuf)
Requires: typelib(Gdm)
Requires: typelib(Geoclue)
Requires: typelib(Gio)
Requires: typelib(GLib)
Requires: typelib(GnomeBluetooth)
Requires: typelib(GnomeDesktop)
Requires: typelib(GObject)
Requires: typelib(Gtk)
Requires: typelib(Gvc)
Requires: typelib(GWeather)
Requires: typelib(IBus)
Requires: typelib(Meta)
Requires: typelib(NM)
Requires: typelib(NMA)
Requires: typelib(Pango)
Requires: typelib(Polkit)
Requires: typelib(PolkitAgent)
Requires: typelib(Rsvg)
Requires: typelib(Shell)
Requires: typelib(Soup)
Requires: typelib(St)
Requires: typelib(TelepathyGLib)
Requires: typelib(TelepathyLogger)
Requires: typelib(UPowerGlib)
Requires: typelib(WebKit2)

BuildRequires(pre): meson rpm-build-gir rpm-build-python3 rpm-build-xdg
BuildRequires: gcc-c++ gnome-common intltool gtk-doc sassc
BuildRequires: python3-devel
BuildRequires: libX11-devel libXfixes-devel
BuildRequires: libmutter-devel >= %mutter_ver libmutter-gir-devel
BuildRequires: libgjs-devel >= %gjs_ver
BuildRequires: libgio-devel >= %gio_ver
BuildRequires: libgtk+3-devel >= %gtk_ver libgtk+3-gir-devel
BuildRequires: at-spi2-atk-devel >= %atspi_ver
BuildRequires: gobject-introspection-devel >= %gi_ver
BuildRequires: libxml2-devel
BuildRequires: libgnome-menus-devel >= %menus_ver libgnome-menus-gir-devel
BuildRequires: libGConf-devel
BuildRequires: libgnome-desktop3-devel >= %desktop_ver
BuildRequires: gcr-libs-devel >= %gcr_ver
BuildRequires: libstartup-notification-devel >= %sn_ver
BuildRequires: libjson-glib-devel >= %json_glib_ver
BuildRequires: libcroco-devel
BuildRequires: libcanberra-devel libcanberra-gtk3-devel
BuildRequires: libalsa-devel libpulseaudio-devel
BuildRequires: libgnome-bluetooth-devel >= %bluetooth_ver libgnome-bluetooth-gir-devel gnome-bluetooth
BuildRequires: evolution-data-server-devel >= %eds_ver libicu-devel
# for screencast recorder functionality
BuildRequires: gstreamer%gst_api_ver-devel >= %gstreamer_ver gst-plugins%gst_api_ver-devel
BuildRequires: libXfixes-devel
BuildRequires: mutter >= %mutter_ver
BuildRequires: libpolkit-devel >= %polkit_ver
BuildRequires: libtelepathy-glib-devel >= %telepathy_ver libtelepathy-glib-gir-devel libtelepathy-logger-gir-devel
BuildRequires: libtelepathy-logger-devel >= %telepathy_logger_ver
BuildRequires: libfolks-devel >= %folks_ver libfolks-gir-devel
BuildRequires: libnm-devel >= %nm_ver libnm-gir-devel
BuildRequires: libgudev-devel libgudev-gir-devel
BuildRequires: gsettings-desktop-schemas-devel >= 3.21.3
BuildRequires: libsoup-gir-devel ca-certificates
BuildRequires: gnome-control-center-devel
BuildRequires: libsystemd-devel
BuildRequires: libibus-devel >= %ibus_ver
BuildRequires: gcr-libs-gir-devel libpolkit-gir-devel
%{?_enable_browser_plugin:BuildRequires: browser-plugins-npapi-devel}

%description
GNOME Shell provides core user interface functions for the GNOME 3 desktop,
like switching to windows and launching applications. GNOME Shell takes
advantage of the capabilities of modern graphics hardware and introduces
innovative user interface concepts to provide a visually attractive and
easy to use experience.

%package data
Summary: Arch independent files for GNOME Shell
Group: Graphical desktop/GNOME
BuildArch: noarch

%description data
This package provides noarch data needed for Gnome Shell to work.

%package devel-doc
Group: Development/Other
Summary: Development documentation for GNOME Shell
Conflicts: %name < %version
BuildArch: noarch

%description devel-doc
This package contains documentation needed to develop extensions for
GNOME Shell.

%set_typelibdir %_libdir/%name

%prep
%setup
%patch3 -b .shells
# fix rpath
subst 's|\(install_rpath: pkg\)datadir|\1libdir|' subprojects/gvc/meson.build
# browser plugin dir
%{?_enable_browser_plugin:subst "s|\(mozplugindir = \).*$|\1'%browser_plugins_path'|" meson.build}
%build
%meson \
	%{?_enable_gtk_doc:-Dgtk_doc=true}
%{?_enable_snapshot:%meson_build %name-pot %name-update-po}
#%meson_build %name-pot %name-update-po
%meson_build

%install
%meson_install
%find_lang %name

%check
%meson_test

%files
%_bindir/*
%_libexecdir/%name-calendar-server
%_libexecdir/%name-perf-helper
%_libexecdir/%name-hotplug-sniffer
%_libexecdir/%name-portal-helper
%_libexecdir/%name-overrides-migration.sh
%dir %_libdir/%name
%_libdir/%name/lib%name.so
%_libdir/%name/lib%name-menu.so
%_libdir/%name/libgvc.so
%_libdir/%name/libst-1.0.so
%_libdir/%name/*.typelib
%{?_enable_browser_plugin:%browser_plugins_path/libgnome-shell-browser-plugin.so}

%files data -f %name.lang
%_xdgconfigdir/autostart/%name-overrides-migration.desktop
%_desktopdir/%xdg_name.desktop
%_desktopdir/%name-extension-prefs.desktop
%_desktopdir/evolution-calendar.desktop
%_desktopdir/%xdg_name.PortalHelper.desktop
%_datadir/%name/
%_datadir/dbus-1/services/%xdg_name.CalendarServer.service
%_datadir/dbus-1/services/%xdg_name.HotplugSniffer.service
%_datadir/dbus-1/interfaces/%xdg_name.Introspect.xml
%_datadir/dbus-1/interfaces/%xdg_name.PadOsd.xml
%_datadir/dbus-1/interfaces/%{xdg_name}SearchProvider.xml
%_datadir/dbus-1/interfaces/%xdg_name.Screenshot.xml
%_datadir/dbus-1/interfaces/%{xdg_name}SearchProvider2.xml
%_datadir/dbus-1/interfaces/%xdg_name.Screencast.xml
%_datadir/dbus-1/interfaces/%xdg_name.Extensions.xml
%_datadir/GConf/gsettings/gnome-shell-overrides.convert
%_datadir/dbus-1/services/%xdg_name.PortalHelper.service
%_datadir/gnome-control-center/keybindings/50-gnome-shell-system.xml
%_datadir/xdg-desktop-portal/portals/%name.portal
%config %_datadir/glib-2.0/schemas/org.gnome.shell.gschema.xml
%config %_datadir/glib-2.0/schemas/00_org.gnome.shell.gschema.override
%_userunitdir/%name-wayland.target
%_userunitdir/%name-x11.target
%_userunitdir/%name.service
%_man1dir/*
%doc README* NEWS

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/shell/
%_datadir/gtk-doc/html/st/
%endif

%changelog
