%define xdg_name org.gnome.Weather
%define ver_major 3.32
%define _libexecdir %_prefix/libexec

Name: gnome-weather
Version: %ver_major.2
Release: alt1

Summary: Access current weather conditions and forecasts
Group: Graphical desktop/GNOME
License: GPLv3+
Url: https://wiki.gnome.org/Apps/Weather

#Source: %name-%version.tar
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

BuildArch: noarch

Obsoletes: %name-data
Provides:  %name-data = %version-%release

%define gtk_ver 3.12
%define gi_ver 1.36.0
%define gjs_ver 1.40.0
%define gweather_ver 3.26.0

Requires: libgweather-gir >= %gweather_ver
Requires: geoclue2

# find ./ -name "*.js" |/usr/lib/rpm/gir-js.req |sort|uniq|sed -e 's/^/Requires: /'
Requires: typelib(GLib)
Requires: typelib(GObject)
Requires: typelib(GWeather)
Requires: typelib(Gdk)
Requires: typelib(Geoclue)
Requires: typelib(Gio)
Requires: typelib(GnomeDesktop)
Requires: typelib(Gtk)

BuildRequires(pre): meson rpm-build-gnome rpm-build-gir
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: libgtk+3-devel >= %gtk_ver libgjs-devel >= %gjs_ver
BuildRequires: libgweather-devel >= %gweather_ver pkgconfig(geoclue-2.0)
BuildRequires: gobject-introspection-devel >= %gi_ver libgtk+3-gir-devel libgweather-gir-devel

%description
%name is a small application that allows you to monitor the current
weather conditions for your city, or anywhere in the world, and to
access updated forecasts provided by various internet services.


%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name %xdg_name

%files -f %name.lang
%_bindir/%name
%_desktopdir/%xdg_name.desktop
%_datadir/%xdg_name/
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/dbus-1/services/%xdg_name.BackgroundService.service
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/scalable/apps/%xdg_name.svg
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%_datadir/gnome-shell/search-providers/%xdg_name.search-provider.ini
%_datadir/metainfo/%xdg_name.appdata.xml
%doc NEWS

%changelog
