# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%add_verify_elf_skiplist %python3_sitelibdir/gns3server/compute/docker/resources/bin/busybox
%add_findreq_skiplist %python3_sitelibdir/gns3server/compute/docker/*

Name: gns3-server
Version: 2.2.11
Release: alt1

Summary: GNS3 server manages emulators such as Dynamips, VirtualBox or Qemu/KVM
License: GPLv3
Group: File tools
Url: https://github.com/GNS3/gns3-server

Buildarch: noarch

Packager: Anton Midyukov <antohami@altlinux.org>

Source: %name-%version.tar

BuildRequires: python3-devel python3-module-setuptools
BuildRequires(pre): rpm-build-python3 rpm-build-gir
Requires: cpulimit
Requires: dynamips >= 0.2.11
Requires: python3-module-yarl >= 1.3
Requires: python3-module-aiohttp >= 3.5.0
Requires: python3-module-aiohttp-cors >= 0.7.0
Requires: python3-module-jinja2 >= 2.7.3 
Requires: python3-module-aiohttp >= 3.5.4
Requires: python3-module-aiofiles >= 0.4.0
Requires: python3-module-async_generator >= 1.10
Requires: python3-module-async-timeout >= 3.0.1
Requires: python3-module-jsonschema >= 2.6.0
Requires: python3-module-raven >= 5.23.0
Requires: python3-module-psutil >= 5.6.6
Requires: iouyap
Requires: ubridge
Requires: vpcs
Conflicts: gns3 < 1.0.0

%description
The GNS3 server manages emulators such as Dynamips, VirtualBox or Qemu/KVM.
Clients like the GNS3 GUI controls the server using a HTTP REST API.

%prep
%setup
echo '' > requirements.txt

%build
%python3_build

%install
%python3_install

%files
%doc AUTHORS LICENSE README.rst
%_bindir/*
%python3_sitelibdir/gns3server
%python3_sitelibdir/gns3_server-*.egg-info
%exclude %python3_sitelibdir/tests/controller

%changelog
