%define ver_major 5.2
%def_with emacs

Name: gnuplot
Version: 5.2.8
Release: alt2
Epoch: 1

Summary: A program for plotting mathematical expressions and data
License: gnuplot and MIT
Group: Sciences/Other
URL: http://www.gnuplot.info/

# git://git.code.sf.net/p/gnuplot/gnuplot-main
Source0: %name-%version.tar
Source2: http://www.gnuplot.info/faq/%name-faq.html.bz2
Source3: %name.desktop
Source4: %name.menu

Source10: %name.16.png
Source11: %name.32.png
Source12: %name.48.png

Source14: gnuplot-emacs.el

Patch1: %name-alt.patch
Patch2: gnuplot-5.0.6-gentoo-no-picins.patch

BuildRequires(pre): rpm-build-tex
BuildPreReq: desktop-file-utils
BuildRequires: gcc-c++ ghostscript-module-X groff-base libXt-devel libncurses-devel libreadline-devel xorg-cf-files zlib-devel libgd3-devel libpng-devel libjpeg-devel libgif-devel
BuildRequires: texinfo latex2html
BuildRequires: dblatex
%{?_with_emacs:BuildRequires: emacs-common}

# for wxt terminal
BuildRequires: libwxGTK-devel libcairo-devel libpango-devel libgtk+2-devel
# for qt terminal
BuildRequires: qt5-base-devel qt5-svg-devel qt5-tools
# for lua/TikZ
BuildRequires: lua-devel tex(pgf.sty)

Requires(post,postun): desktop-file-utils
Requires: fonts-ttf-dejavu
Requires: %name-common-x11 = %EVR

Summary(ru_RU.UTF-8): Программа для построения графиков математических выражений и данных

%package common
Group: Sciences/Other
Summary: The common gnuplot parts
BuildArch: noarch
Conflicts: %name < %EVR

%package common-x11
Group: Sciences/Other
Summary: The common-x11 gnuplot parts
Requires: %name-common = %EVR
Conflicts: %name < %EVR

%package minimal
Group: Sciences/Other
Summary: Minimal version of program for plotting mathematical expressions and data
Requires: %name-common = %EVR

%package qt
Group: Sciences/Other
Summary: Qt interface for gnuplot
Requires: %name-common-x11 = %EVR

%package doc
Group: Documentation
Summary: Documentation of bindings for the gnuplot main application
BuildArch: noarch

%package demo
Group: Sciences/Other
Summary: Demo gnuplot applications
BuildArch: noarch

%description
Gnuplot is a command-line driven, interactive function plotting program
especially suited for scientific data representation. Gnuplot can be used to
plot functions and data points in both two and three dimensions and in many
different formats.

Install gnuplot if you need a graphics package for scientific data
representation.

%description -l ru_RU.UTF-8
Gnuplot это интерактивная программа, предназначенная для построения
графиков.  Она особенно хорошо подходит для представления научных 
данных.  Gnuplot может строить 2-х и 3-х мерные графики функций 
и числовых данных во множестве различных графических форматов.

%description common
Gnuplot is a command-line driven, interactive function plotting
program especially suited for scientific data representation.  Gnuplot
can be used to plot functions and data points in both two and three
dimensions and in many different formats.

This subpackage contains common parts needed for arbitrary version of gnuplot

%description common-x11
Gnuplot is a command-line driven, interactive function plotting
program especially suited for scientific data representation.  Gnuplot
can be used to plot functions and data points in both two and three
dimensions and in many different formats.

This subpackage contains common-x11 parts needed for arbitrary version of gnuplot

%description minimal
Gnuplot is a command-line driven, interactive function plotting
program especially suited for scientific data representation.  Gnuplot
can be used to plot functions and data points in both two and three
dimensions and in many different formats.


%description qt
Gnuplot is a command-line driven, interactive function plotting
program especially suited for scientific data representation.  Gnuplot
can be used to plot functions and data points in both two and three
dimensions and in many different formats.

This package provides a Qt based terminal version of gnuplot

%description doc
The gnuplot-doc package contains the documentation related to gnuplot
plotting tool

%description demo
The gnuplot-demo package contains the demo applications related to gnuplot
plotting tool

%prep
%setup
%patch1 -p1
%patch2 -p1

%build
#export CFLAGS="$RPM_OPT_FLAGS -fno-fast-math"
%ifarch %e2k
# lcc 1.23.12 is -std=c++03 by default but c++11 capable;
# src/qtterminal/qt_term.cpp compilation needs that
export CXXFLAGS+=-std=c++11
%endif

%define configure_opts --with-readline=gnu --with-png --with-pdf --enable-history-file --without-linux-vga --without-row-help --enable-thin-splines --with-texdir=%_texmfmain/%name --with-lua --with-gihdir=%name/%ver_major

sh prepare
%autoreconf

# at first create minimal version of gnuplot for server SIG purposes
mkdir minimal
cd minimal
ln -s ../configure .
%configure %configure_opts --disable-wxwidgets --without-cairo --without-qt --without-x
%make_build
cd -

# create full version of gnuplot
mkdir wx
cd wx
ln -s ../configure .
%configure %configure_opts --without-qt
%make_build
cd -

mkdir qt
cd qt
ln -s ../configure .
%configure %configure_opts --disable-wxwidgets --enable-qt
%make_build
cd -


install -p -m644 %SOURCE2 .
bunzip *.html.bz2

# Docs don't build properly out of tree
%configure  %configure_opts --with-tutorial
ln -s ../wx/src/gnuplot src/
export PERL5LIB=$(pwd)/docs:$(pwd)/docs/htmldocs
ln -s ../VERSION docs/VERSION
make -C docs html pdf
export GNUPLOT_PS_DIR=../../term/PostScript
make -C docs/psdoc ps_symbols.ps ps_fontfile_doc.pdf
rm -rf docs/htmldocs/images.idx
make -C tutorial
make -C docs gih

%install
# install wx
%makeinstall_std -C wx
# rename binary
mv %buildroot%_bindir/%name %buildroot%_bindir/%name-wx

# install qt
%makeinstall_std -C qt
# rename binary
mv %buildroot%_bindir/%name %buildroot%_bindir/%name-qt

# install minimal binary
install -p -m 755 minimal/src/%name %buildroot%_bindir/%name-minimal

# install docs
%makeinstall_std -C docs

# Add alternatives for gnuplot
mkdir -p %buildroot%_altdir
printf '%_bindir/%name\t%_bindir/gnuplot-minimal\t10\n' > %buildroot%_altdir/%name-minimal
printf '%_bindir/%name\t%_bindir/gnuplot-wx\t20\n' > %buildroot%_altdir/%name-wx
printf '%_bindir/%name\t%_bindir/gnuplot-qt\t30\n' > %buildroot%_altdir/%name-qt

# menus
install -D -pm644 %SOURCE3  %buildroot%_desktopdir/%name.desktop

# icon
install -D -pm644 %SOURCE10  %buildroot/%_miconsdir/%name.png
install -D -pm644 %SOURCE11  %buildroot/%_niconsdir/%name.png
install -D -pm644 %SOURCE12  %buildroot/%_liconsdir/%name.png

# help data
cp docs/%{name}.gih %buildroot%_datadir/%name/%ver_major/

# cleanup before add to doc
rm -f demo/Makefile*
rm -f demo/html/Makefile*

%files
%_bindir/gnuplot-wx
%_altdir/%name-wx

%files common
%_mandir/man?/*
%_datadir/%name
%exclude %_datadir/%name/%ver_major/qt
%_desktopdir/*
%_niconsdir/*.png
%_miconsdir/*.png
%_liconsdir/*.png
%_texmfmain/%name
%dir %_libexecdir/%name
%dir %_libexecdir/%name/%ver_major

%files common-x11
%_libexecdir/%name/%ver_major/%{name}_x11

%files minimal
%_bindir/gnuplot-minimal
%_altdir/%name-minimal

%files qt
%_bindir/%name-qt
%_altdir/%name-qt
%_libexecdir/%name/%ver_major/%{name}_qt
%_datadir/%name/%ver_major/qt

%files doc
%doc ChangeLog Copyright BUGS README NEWS RELEASE_NOTES
%doc tutorial/tutorial.dvi gnuplot-faq.html
%doc docs/psdoc/ps_* docs/gnuplot.pdf docs/htmldocs

%files demo
%doc demo

%changelog
