%define _sbindir /sbin

Name: gpart
Version: 0.3
Release: alt1

Summary: Hard disk partition table reconstruction
Group: System/Configuration/Hardware
License: GPL
Url: https://github.com/baruch/%name/
Packager: Michael Shigorin <mike@altlinux.org>

Source: %url/archive/%version.tar.gz#/%name-%version.tar.gz
Patch: %name-0.3-alt-lfs.patch

Requires: common-licenses

BuildRequires: common-licenses

Summary(ru_RU.UTF-8): Восстановление таблицы разделов жёсткого диска

%description
A tool which tries to guess the partition table of a PC-type
hard disk in case the primary partition table in sector 0 is damaged,
incorrect or deleted.  This is performed by analyzing either hard
disk or its exact copy.

The guessed table can be written to a file or device. Supported
(guessable) filesystem or partition types: DOS/Windows FAT, Linux
ext2 and swap, OS/2 HPFS, Windows NTFS, FreeBSD and Solaris/x86
disklabels, Minix FS, QNX 4 FS, Reiser FS, LVM physical volumes,
BeOS FS, SGI XFS.

%description -l ru_RU.UTF-8
Эта программа пытается определить расположение разделов на
жестком диске в случае, если таблица разделов повреждена,
нарушена или удалена. Для этого анализируется содержимое жесткого
диска (или его побитовой копии). Воссозданная на основании
собранных данных таблица разделов может быть записана в файл или
на устройство.

Поддерживаются следующие типы разделов: DOS/Windows FAT, Linux
ext2 и swap, OS/ 2 HPFS, Windows NTFS, FreeBSD и Solaris/x86
disklabels, Minix FS, QNX 4 FS, Reiser FS, физические тома LVM,
BeOS FS, SGI XFS.

%prep
%setup
%patch

%build
%autoreconf
%configure
%make_build
ln -sf %_licensedir/GPL-2 COPYING

%install
%makeinstall mandir=%buildroot%_mandir bindir=%buildroot/sbin

%files
/sbin/%name
%_man8dir/%name.8*
%doc README* Changes
%doc --no-dereference COPYING

%changelog
