%def_with libQgpsmm
%define abiversion 25

Name: gpsd
Summary: Service daemon for mediating access to a GPS
Version: 3.20
Release: alt5
License: BSD-2-Clause
Group: System/Servers
Url: http://www.catb.org/gpsd
Packager: Anton V. Boyarshinov <boyarsh@altlinux.ru>

Source: %name-%version.tar
Requires: libgps%abiversion = %version-%release

Patch0: gpsd-3.20-SConstruct.patch

BuildRequires: asciidoc docbook-dtds docbook-style-xsl scons gcc-c++ libXaw-devel libXext-devel libXpm-devel libdbus-glib-devel xorg-cf-files xsltproc libgtk+3-devel

BuildRequires: python3-dev python3-module-pycairo python3-module-pygobject3 python3-module-anyjson python3-module-serial

%if_with libQgpsmm
BuildRequires: qt5-base-devel
%endif

BuildRequires: libbluez-devel
BuildRequires: libusb-devel

%set_verify_elf_method unresolved=relaxed

%description
gpsd is a service daemon that mediates access to a GPS sensor
connected to the host computer by serial or USB interface, making its
data on the location/course/velocity of the sensor available to be
queried on TCP port 2947 of the host computer.  With gpsd, multiple
GPS client applications (such as navigational and wardriving software)
can share access to a GPS without contention or loss of data.  Also,
gpsd responds to queries with a format that is substantially easier to
parse than NMEA 0183.  A client library is provided for applications.

After installing this RPM, gpsd will automatically connect to USB
GPSes when they are plugged in and requires no configuration.  For
serial GPSes, you will need to start gpsd by hand.  Once connected,
the daemon automatically discovers the correct baudrate, stop bits,
and protocol. The daemon will be quiescent when there are no
clients asking for location information, and copes gracefully when the
GPS is unplugged and replugged.

%package -n libgps%abiversion
Summary: Client libraries in C and Python for talking to a running gpsd or GPS
Group: Sciences/Geosciences
%description -n libgps%abiversion
Client libraries in C and Python for talking to a running gpsd or GPS

%if_with libQgpsmm
%package -n libQgpsmm%abiversion
Summary: Qt bindings for gpsd
Group: Sciences/Geosciences
%description -n libQgpsmm%abiversion
This package contains Qt bindings for gpsd
%endif

%package -n libgps-devel
Summary: Development files for libgps
Group: Development/C
Requires: libgps%abiversion = %version-%release
%if_with libQgpsmm
Requires: libQgpsmm%abiversion = %version-%release
%endif

%description -n libgps-devel
Development files for libgps

%package -n gpsd-clients
Summary: Clients for gpsd with an X interface
Group: Sciences/Geosciences
Requires: libgps%abiversion = %version-%release
Requires: python3-module-gps = %version-%release

%description -n gpsd-clients
xgpsspeed is a speedometer that uses position information from the GPS.
It accepts an -h option and optional argument as for gps, or a -v option
to dump the package version and exit. Additionally, it accepts -rv
(reverse video) and -nc (needle color) options.

cgps resembles xgps, but without the pictorial satellite display.  It
can run on a serial terminal or terminal emulator.

%package -n python3-module-gps
Summary: Python bindings to libgps
Group: Development/Python

%description -n python3-module-gps
Python bindings to libgps

%prep
%setup

%patch0 -p2

# don't set RPATH
#sed -i 's|env.Prepend.*RPATH.*|pass #\0|' SConstruct

# fixed linking with libm
#sed -i 's|parse_flags=usblibs . rtlibs . bluezlibs . ."-lgps".|parse_flags=usblibs + rtlibs + bluezlibs + ["-lgps", "-lm"]|' SConstruct

# fixed binary's path, exit with 1 when not found
sed -i '/\/usr\/local\/sbin/{s||%_sbindir|;h};${x;/./{x;q0};x;q1}' systemd/gpsd.service
sed -i '/\/usr\/local\/sbin/{s||%_sbindir|;h};${x;/./{x;q0};x;q1}' systemd/gpsdctl@.service

sed -i 's|/usr/bin/python|%__python3|' contrib/gpsData.py
find -type f -name "*.py" -exec sed -i 's|/usr/bin/env python|%__python3|' {} \;
for FILE in gegps gpscat gpsfake gpsprof ubxtool xgps xgpsspeed zerk ; do
   sed -i 's|/usr/bin/env python|%__python3|' $FILE
done

%build
scons \
    prefix=/usr \
    libdir=%_libdir \
    python_libdir=%python3_sitelibdir \
    target_python=%__python3 \
    %if_with libQgpsmm
	qt=yes \
	qt_versioned=5 \
    %else
	 qt=no \
    %endif
    debug=yes

%install
DESTDIR=%buildroot scons install udev-install

%files
%doc README.adoc INSTALL.adoc COPYING
%_sbindir/gpsd
%_sbindir/gpsdctl
%_unitdir/gpsd.service
%_unitdir/gpsd.socket
%_unitdir/gpsdctl@.service
%_udevrulesdir/*.rules

%_man8dir/gps*
%_man8dir/ppscheck.*
%_man5dir/*

%files -n libgps%abiversion
%_libdir/libgps*.so.%abiversion
%_libdir/libgps*.so.%abiversion.*

%if_with libQgpsmm
%files -n libQgpsmm%abiversion
%_libdir/libQgps*.so.%abiversion
%_libdir/libQgps*.so.%abiversion.*
%endif

%files -n libgps-devel
%if_with libQgpsmm
%_libdir/libQgpsmm.so
%_libdir/libQgpsmm.prl
%endif
%_libdir/libgps*.so
%_pkgconfigdir/*.pc
%_includedir/*.h
%_man3dir/*

%files -n gpsd-clients
%_bindir/*
%_man1dir/*

%files -n python3-module-gps
%python3_sitelibdir/gps/
%python3_sitelibdir/*.egg-info

%changelog
