%def_disable snapshot
%define _name gst-plugins
%define ver_major 1.16
%define api_ver 1.0

%define _gst_libdir %_libdir/gstreamer-%api_ver
%define _gtk_docdir %_datadir/gtk-doc/html

%ifarch %e2k
# https://gitlab.gnome.org/GNOME/gnome-build-meta/issues/38
# https://gitlab.freedesktop.org/gstreamer/gst-plugins-base/issues/564
%def_disable gtk_doc
%else
%def_enable gtk_doc
%endif
%def_disable debug
%def_disable libunwind
%def_disable libdw
%def_disable examples
%def_disable check

Name: %_name-base%api_ver
Version: %ver_major.1
Release: alt1

Summary: An essential set of GStreamer plugins
Group: System/Libraries
License: LGPL
Url: http://gstreamer.freedesktop.org/

%if_disabled snapshot
Source: http://gstreamer.freedesktop.org/src/%_name-base/%_name-base-%version.tar.xz
%else
Source: %_name-base-%version.tar
%endif

Provides: %_name-base = %version-%release

Requires: lib%_name%api_ver = %version-%release
Requires: gstreamer%api_ver >= %ver_major
Conflicts: gst-plugins-bad%api_ver < %ver_major

Provides: gstreamer%api_ver(audio-hardware-sink) = %version
Provides: gstreamer%api_ver(audio-hardware-source) = %version

%define opus_ver 0.9.4

BuildRequires(pre): meson rpm-build-gir
BuildRequires: gcc-c++ orc >= 0.4.18 liborc-test-devel gtk-doc
BuildRequires: gstreamer%api_ver-devel >= %version libgstreamer%api_ver-gir-devel
BuildRequires: libgudev-devel libGL-devel libGLES-devel libdrm-devel libgbm-devel
BuildRequires: libwayland-client-devel libwayland-cursor-devel libwayland-egl-devel wayland-protocols
BuildRequires: libgraphene-devel libjpeg-devel libpng-devel
BuildRequires: libXext-devel libXv-devel libSM-devel libalsa-devel libgtk+3-devel libvisual0.4-devel iso-codes-devel
BuildRequires: libcdparanoia-devel libtheora-devel libvorbis-devel libopus-devel >= %opus_ver
BuildRequires: python-module-PyXML python-modules-encodings python-modules-distutils
BuildRequires: gobject-introspection-devel
%{?_enable_libunwind:BuildRequires: libunwind-devel}
%{?_enable_libdw:BuildRequires: libdw-devel}
%{?_enable_check:BuildRequires: /proc gstreamer%api_ver}

%description
GStreamer Base Plug-ins is a well-groomed and well-maintained
collection of GStreamer plug-ins and elements, spanning the range of
possible types of elements one would want to write for GStreamer. A
wide range of video and audio decoders, encoders, and filters are
included.

%package -n lib%_name%api_ver
Summary: GStreamer plugin libraries
Group: System/Libraries
Provides: lib%_name = %version-%release
# GstGL moved from bad to base in 1.13
# https://bugzilla.altlinux.org/show_bug.cgi?id=35636
Conflicts: gst-plugins-bad%api_ver < 1.13

%description -n lib%_name%api_ver
Helper libraries for GStreamer plugins, containing base classes useful for elements

%package -n lib%_name%api_ver-gir
Summary: GObject introspection data for the GStreamer library
Group: System/Libraries
Provides: lib%_name-gir = %version-%release
Requires: lib%_name%api_ver = %version-%release

%description -n lib%_name%api_ver-gir
GObject introspection data for the GStreamer library

%package -n %_name%api_ver-tools
Summary: GStreamer plugin tools
Group: Development/Other
Provides: %_name-tools = %version-%release
Requires: %name = %version-%release

%description -n %_name%api_ver-tools
This package contains a few test tools from the
GStreamer Base Plugins distribution.

%package -n %_name%api_ver-devel
Summary: Development files for GStreamer plugins
Group: Development/C
Provides: %_name-devel = %version-%release
Requires: lib%_name%api_ver = %version-%release
Requires: gstreamer%api_ver-devel

%description -n %_name%api_ver-devel
This package contains the libraries, headers and other files necessary
to develop GStreamer plugins.

%package -n %_name%api_ver-devel-doc
Summary: Development documentation for GStreamer Base plugins
Group: Development/Documentation
BuildArch: noarch
Provides: %_name-devel-doc = %version-%release

%description -n %_name%api_ver-devel-doc
This package contains development documentation for GStreamer Base Plugins

%package -n %_name%api_ver-gir-devel
Summary: GObject introspection devel data for the GStreamer library
Group: System/Libraries
BuildArch: noarch
Provides: %_name-gir-devel = %version-%release
Requires: lib%_name%api_ver-gir = %version-%release
Requires: %_name%api_ver-devel = %version-%release

%description -n %_name%api_ver-gir-devel
GObject introspection devel data for the GStreamer library

%prep
%setup -n %_name-base-%version

%build
%meson \
	-Dexamples=disabled \
	-Dgio=enabled \
	%{?_enable_check:-Dtests=enabled} \
	%{?_disable_gtk_doc:-Dgtk_doc=disabled} \
	%{?_enable_debug:-Dgst_debug=true}

%meson_build

%install
%meson_install
%find_lang %_name-base-%api_ver

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files -f %_name-base-%api_ver.lang
%dir %_gst_libdir
%_gst_libdir/*.so
%_datadir/%_name-base/%api_ver/*.dict

%files -n lib%_name%api_ver
%_libdir/*.so.*
%dir %_gst_libdir

%files -n lib%_name%api_ver-gir
%_typelibdir/GstAllocators-1.0.typelib
%_typelibdir/GstApp-%api_ver.typelib
%_typelibdir/GstAudio-%api_ver.typelib
%_typelibdir/GstPbutils-%api_ver.typelib
%_typelibdir/GstGL-%api_ver.typelib
%_typelibdir/GstRtp-%api_ver.typelib
%_typelibdir/GstRtsp-%api_ver.typelib
%_typelibdir/GstSdp-%api_ver.typelib
%_typelibdir/GstTag-%api_ver.typelib
%_typelibdir/GstVideo-%api_ver.typelib

%files -n %_name%api_ver-tools
%_bindir/*-%api_ver
%_man1dir/*

%files -n %_name%api_ver-devel
%_includedir/*
%_libdir/gstreamer-%api_ver/include/gst/gl/gstglconfig.h
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled gtk_doc
%files -n %_name%api_ver-devel-doc
%_gtk_docdir/%_name-base-*/
%endif

%files -n %_name%api_ver-gir-devel
%_girdir/GstAllocators-1.0.gir
%_girdir/GstApp-%api_ver.gir
%_girdir/GstAudio-%api_ver.gir
%_girdir/GstGL-%api_ver.gir
%_girdir/GstPbutils-%api_ver.gir
%_girdir/GstRtp-%api_ver.gir
%_girdir/GstRtsp-%api_ver.gir
%_girdir/GstSdp-%api_ver.gir
%_girdir/GstTag-%api_ver.gir
%_girdir/GstVideo-%api_ver.gir


%changelog
