%define _name gst-plugins
%define ver_major 1.16
%define api_ver 1.0

%define _gst_datadir %_datadir/gstreamer-%api_ver
%define _gst_libdir %_libdir/gstreamer-%api_ver
%define _gtk_docdir %_datadir/gtk-doc/html

%def_enable jack
%def_enable pulse
%def_enable qt5

%def_disable gtk_doc
%def_disable debug
%def_disable examples
%ifarch %ix86 x86_64 aarch64
%def_enable valgrind
%endif
%def_disable check

Name: %_name-good%api_ver
Version: %ver_major.1
Release: alt1

Summary: A set of GStreamer plugins considered good
Group: System/Libraries
License: LGPL
Url: http://gstreamer.freedesktop.org/

Source: http://gstreamer.freedesktop.org/src/%_name-good/%_name-good-%version.tar.xz

Provides: %_name-good = %version-%release

BuildRequires(pre): meson
BuildRequires: bzlib-devel gcc-c++ gst-plugins%api_ver-devel >= %version
BuildRequires: gtk-doc libSM-devel libXdamage-devel libXext-devel libXfixes-devel
BuildRequires: libXv-devel libavc1394-devel libcairo-devel libdv-devel libflac-devel libiec61883-devel libjpeg-devel
BuildRequires: libshout2-devel libsoup-devel libtag-devel libv4l-devel libwavpack-devel
BuildRequires: python-module-PyXML python-modules-email python-modules-encodings python-modules-distutils
BuildRequires: liborc-devel orc libgdk-pixbuf-devel
BuildRequires: libpng-devel libcairo-gobject-devel libgudev-devel libspeex-devel zlib-devel libvpx-devel
BuildRequires: libmpg123-devel liblame-devel
BuildRequires: libgtk+3-devel
BuildRequires: liborc-test-devel
%{?_enable_valgrind:BuildRequires: valgrind-tool-devel}
%{?_enable_jack:BuildRequires: libjack-devel}
%{?_enable_pulse:BuildRequires: libpulseaudio-devel}
%{?_enable_qt5:BuildRequires: qt5-base-devel qt5-declarative-devel qt5-x11extras-devel qt5-wayland-devel}
%{?_enable_check:BuildRequires: /proc gstreamer%api_ver}

%description
GStreamer Good Plug-ins is is a set of plug-ins that the developers consider
to have good quality code, correct functionality, and their preferred license
(LGPL for the plug-in code, LGPL or LGPL-compatible for the supporting
library).

%package qt5
Summary: Qt5 plugin for GStreamer
Group: System/Libraries
Requires: gst-plugins-base%api_ver >= %version

%description qt5
This package contains Qt5 GL plugin for Gstreamer.


%package devel-doc
Summary: Development documentation for GStreamer Good plugins
Group: Development/Documentation
BuildArch: noarch
Provides: %_name-good-devel-doc = %version-%release

%description devel-doc
This package contains development documentation for GStreamer Good Plugins

%prep
%setup -n %_name-good-%version

%build
%meson \
	-Dexamples=disabled \
	%{?_enable_check:-Dtests=enabled} \
	%{?_disable_gtk_doc:-Dgtk_doc=disabled} \
	%{?_enable_debug:-Dgst_debug=true}

%meson_build

%install
%meson_install
%find_lang %_name-good-%api_ver

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files -f %_name-good-%api_ver.lang
%_gst_libdir/*.so
%{?_enable_qt5:%exclude %_gst_libdir/libgstqmlgl.so}
%_gst_datadir/*
%doc AUTHORS NEWS README RELEASE

%if_enabled qt5
%files qt5
%_gst_libdir/libgstqmlgl.so
%endif

%if_enabled gtk_doc
%files devel-doc
%_gtk_docdir/*
%endif

%changelog
