%define _name gst-plugins
%define ver_major 1.16
%define api_ver 1.0

%define _gst_datadir %_datadir/gstreamer-%api_ver
%define _gst_libdir %_libdir/gstreamer-%api_ver
%define _gtk_docdir %_datadir/gtk-doc/html

%def_disable gtk_doc
%def_disable debug
%def_disable examples
%def_disable check

Name: %_name-ugly%api_ver
Version: %ver_major.1
Release: alt1

Summary: A set of encumbered GStreamer plugins
Group: System/Libraries
License: LGPL
Url: http://gstreamer.freedesktop.org/

Provides: %_name-ugly = %version-%release

Requires: gstreamer%api_ver >= %ver_major
Requires: lib%_name%api_ver >= %ver_major

Provides: %_name%api_ver-lame = %version-%release
Provides: %_name%api_ver-mad = %version-%release

Source: http://gstreamer.freedesktop.org/src/%_name-ugly/%_name-ugly-%version.tar.xz

BuildRequires(pre): meson
BuildRequires: gcc-c++ orc liborc-test-devel gst-plugins%api_ver-devel >= %version
BuildRequires: gtk-doc liba52-devel libcdio-devel libid3tag-devel
BuildRequires: libmad-devel libmpeg2-devel liboil-devel libx264-devel
BuildRequires: python-module-PyXML python-modules-encodings python-modules-distutils
BuildRequires: libopencore-amrnb-devel libopencore-amrwb-devel libdvdread-devel

%description
GStreamer Ugly Plug-ins is a set of plug-ins that have good quality
and correct functionality, but distributing them might pose problems.
The license on either the plug-ins or the supporting
libraries might not be how the developers would like.
The code might be widely known to present patent problems.

%package devel-doc
Summary: Development documentation for GStreamer Ugly plugins
Group: Development/Documentation
BuildArch: noarch
Provides: %_name-ugly-devel-doc = %version-%release

%description devel-doc
This package contains development documentation for GStreamer Ugly plugin
collection.

%prep
%setup -n %_name-ugly-%version

%build
%meson \
	-Dexamples=disabled \
	%{?_enable_check:-Dtests=enabled} \
	%{?_disable_gtk_doc:-Dgtk_doc=disabled} \
	%{?_enable_debug:-Dgst_debug=true}

%meson_build

%install
%meson_install
%find_lang %_name-ugly-%api_ver

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files -f %_name-ugly-%api_ver.lang
%doc AUTHORS NEWS README RELEASE
%_gst_libdir/*.so
%_datadir/gstreamer-%api_ver/*

%if_enabled gtk_doc
%files devel-doc
%_gtk_docdir/%_name-ugly-plugins-%api_ver/*
%endif

%changelog
