Name: gutenprint
Version: 5.3.4
Release: alt1
Epoch: 1
Summary: Gutenprint Printer Drivers
License: GPL-2.0+
Group: Publishing
Requires: lib%name = %EVR, ghostscript
Url: http://gimp-print.sourceforge.net/
Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar
Source1: %name.watch
Source2: ru.po

Patch0: gutenprint-5.3.1-alt-fixes.patch
Patch1: gutenprint-5.2.9-alt-makefile.patch
Patch2: gutenprint-alt-LFS.patch
Patch3: gutenprint-alt-link-plugins-with-libraries.patch

BuildRequires: flex foomatic-db-engine libcups-devel libgimp-devel libreadline-devel
BuildRequires: libusb-devel
BuildRequires: chrpath

%description
Gutenprint is a package of high quality printer drivers for Linux and
other UNIX-alike operating systems.
Gutenprint was formerly called Gimp-Print.

%package -n lib%name
Summary: Shared libraries for high-quality image printing
Group: Publishing

%description -n lib%name
Gutenprint is a package of high quality printer drivers for Linux and
other UNIX-alike operating systems.

This package contains gutenprint shared libraries.

%package -n lib%name-devel
Summary: Library development files for gutenprint
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
Gutenprint is a package of high quality printer drivers for Linux and
other UNIX-alike operating systems.

This package contains header files and libraries required to build
gutenprint-based software.

%package -n gimp-plugin-%name
Summary: GIMP plug-in for %name
Group: Publishing
Requires: %name = %EVR gimp

%description -n gimp-plugin-%name
Gutenprint is a package of high quality printer drivers for Linux and
other UNIX-alike operating systems.

This package contains the gutenprint GIMP plug-in.

%package cups
Summary: CUPS drivers for Canon, Epson, HP and compatible printers
Group: System/Configuration/Hardware
Provides: %name-CUPS = %EVR
Obsoletes: %name-CUPS < %EVR
Requires: %name = %EVR

%description cups
Gutenprint is a package of high quality printer drivers for Linux and
other UNIX-alike operating systems.

This package contains native CUPS support for a wide range of Canon,
Epson, HP and compatible printers.

%package cups-ppds
Summary: PPDs for CUPS drivers for Canon, Epson, HP and compatible printers
Group: System/Configuration/Hardware
Requires: %name-cups = %EVR
BuildArch: noarch

%description cups-ppds
Gutenprint is a package of high quality printer drivers for Linux and
other UNIX-alike operating systems.

This package contains PPDs for gutenprint-cups.

%prep
%setup
%patch0 -p2
%patch1 -p1
%patch2 -p2
%patch3 -p2
rm -rf gutenprint/po/*.gmo
install %SOURCE2 po/ru.po

%build
%undefine _configure_gettext
# remove old versions of standard macros
find m4* -type f -name \*.m4 -print0 |
	xargs -r0 grep -lxZ 'dnl Copyright (C) .* Free Software Foundation, Inc\.' -- |
	xargs -r0 rm -v --
#rm m4*/libtool.m4
%autoreconf
%configure \
	--enable-shared \
	--disable-static \
	--disable-rpath \
	--with-modules=dlopen \
	--with-cups \
	--with-gimp2 \
	--with-gimp2-as-gutenprint \
	--enable-libgutenprintui2 \
	--enable-cups-ppds \
	--enable-cups-level3-ppds \
	--enable-cups-ppds-at-top-level

%make_build

%install
%makeinstall_std
%define docdir %_docdir/%name-%version
mkdir -p %buildroot%_docdir
mv %buildroot%_datadir/%name/doc %buildroot%docdir
find %buildroot%_libdir/%name/ -name \*.la -delete
chmod +rx %buildroot%_prefix/lib/cups/backend/gutenprint*+usb

# Remove standard library path from rpath
for file in \
  %buildroot%_bindir/* \
  %buildroot%_sbindir/cups-genppd.5.3 \
  %buildroot%_libdir/gimp/*/plug-ins/* \
  %buildroot%_libdir/*.so.* \
  %buildroot%_libexecdir/cups/driver/* \
  %buildroot%_libexecdir/cups/filter/* 
do \
  chrpath --delete ${file}
done

%find_lang %name
%set_verify_elf_method strict

%triggerpostun cups -- %name-cups < %version
cups=%_initdir/cups
if [ -x $cups ] && %_sbindir/cups-genppdupdate | grep -Fqs Restart; then
	$cups condreload
fi

%files -f %name.lang
%_bindir/escputil
%_bindir/testpattern
%_datadir/%name/
%_man1dir/*.1*
%exclude %_datadir/locale/*/gutenprint_*.po
%dir %docdir
%docdir/[AFNR]*
%docdir/gutenprint-users-manual.pdf
%exclude %docdir/gutenprint-users-manual.odt
%exclude %docdir/C*

%files -n lib%name
%_libdir/*.so.*
%_libdir/%name

%files -n lib%name-devel
%_includedir/%{name}*
%_libdir/*.so
%_pkgconfigdir/*.pc
%dir %docdir
%docdir/%name.pdf
%docdir/reference-html

%files -n gimp-plugin-%name
%_libdir/gimp/2.0/plug-ins/%name

%files cups
%_sysconfdir/cups/*
%_bindir/cups-*
%_sbindir/cups-*
%_prefix/lib/cups/backend/gutenprint*+usb
%_prefix/lib/cups/driver/%{name}*
%_prefix/lib/cups/filter/*
%_datadir/cups/usb/net.sf.gimp-print.usb-quirks
%_datadir/cups/calibrate.ppm
%_man8dir/*.8*

%files cups-ppds
%_datadir/cups/model/Global

%changelog
