%def_disable snapshot

%def_enable pulse
%define ver_major 2
%define api_ver 2.0
%def_disable qt5

Name: guvcview
Version: %ver_major.0.6
Release: alt1

Summary: A GTK UVC video viewer
License: GPLv3+
Group: Video
Url: http://%name.sourceforge.net/

%if_disabled snapshot
Source: http://download.sourceforge.net/%name/%name-src-%version.tar.gz
%else
# VCS: git://git.code.sf.net/p/guvcview/git-master
Source: %name-%version.tar
%endif

Requires: lib%name = %version-%release

BuildPreReq: libSDL2-devel >= 2.0.0
BuildRequires: gcc-c++ glibc-kernheaders
BuildRequires: desktop-file-utils intltool libappstream-glib-devel
BuildRequires: libavutil-devel libavcodec-devel
BuildRequires: libgtk+3-devel libportaudio2-devel
BuildRequires: libv4l-devel libpng-devel libudev-devel libusb-devel
BuildRequires: libgsl-devel
%{?_enable_pulse:BuildRequires: libpulseaudio-devel}
%{?_enable_qt5:BuildRequires: qt5-base-devel qt5-tools}
# for autoreconf
BuildRequires: autoconf-archive

%description
This project aims at providing a simple GTK interface for capturing and
viewing video from devices supported by the linux UVC driver. The
software is based on luvcview  but uses a GTK interface, allowing for a
more user friendly GUI

%package -n lib%name
Summary: GTK UVC video viewer libraries
Group: System/Libraries

%description -n lib%name
This project aims at providing a simple GTK interface for capturing and
viewing video from devices supported by the linux UVC driver. The
software is based on luvcview  but uses a GTK interface, allowing for a
more user friendly GUI.

This package contains GTK UVC video viewer libraries.

%package -n lib%name-devel
Summary: GTK UVC video viewer development files
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains files necessary to develop applications that use
%name libraries.

%prep
%setup -n %name-src-%version

%build
export LIBS="$LIBS -lm"
%{?_enable_qt5: export ac_cv_prog_MOC=%_bindir/moc-qt5}
%autoreconf
%configure \
	--disable-static \
	--disable-debian-menu \
	%{?_disable_pulse:--enable-pulse=no} \
	%{subst_enable qt5}
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_niconsdir
install -p -m644 %buildroot%_pixmapsdir/guvcview/guvcview.png %buildroot%_niconsdir/guvcview.png
rm -f %buildroot%_pixmapsdir/guvcview/guvcview.png
ln -s %_niconsdir/guvcview.png %buildroot%_pixmapsdir/guvcview/guvcview.png

desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=Recorder \
	--add-category=Video \
	%buildroot%_desktopdir/guvcview.desktop

%find_lang --output=%name.lang %name gview_v4l2core

%files -f %name.lang
%_bindir/%name
%_desktopdir/%name.desktop
%_pixmapsdir/*
%_niconsdir/*
%_man1dir/*
%_datadir/appdata/%name.appdata.xml
%doc AUTHORS ChangeLog NEWS README*

%files -n lib%name
%_libdir/libgviewaudio-%api_ver.so.*
%_libdir/libgviewrender-%api_ver.so.*
%_libdir/libgviewv4l2core-%api_ver.so.*
%_libdir/libgviewencoder-%api_ver.so.*

%files -n lib%name-devel
%_includedir/%name-%ver_major/
%_libdir/*.so
%_pkgconfigdir/*.pc

%exclude %_datadir/doc/%name

%changelog
