%def_enable snapshot

%define ver_major 1.40

%def_disable gdu
%def_disable gtk_doc
# obexftp support removed since 3.15.91
%def_disable obexftp
%def_enable afc
%def_enable afp
%def_enable archive
%def_enable avahi
%def_enable bluray
%def_enable cdda
%def_enable fuse
%def_enable gcr
%def_enable goa
%def_enable gphoto2
%def_enable http
%def_enable installed_tests
%def_enable keyring
%def_enable libmtp
%def_enable nfs
%def_enable samba
%def_enable systemd_login
%def_enable udisks2
%def_enable google
%def_enable admin
%def_enable libusb
%def_enable dnssd
%def_enable man
%def_disable check

Name: gvfs
Version: %ver_major.2
Release: alt1

Summary: The GNOME virtual filesystem libraries
License: %lgpl2plus
Group: System/Libraries
Url: https://wiki.gnome.org/Projects/gvfs

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
# https://bugzilla.altlinux.org/show_bug.cgi?id=29047
# https://bugzilla.altlinux.org/show_bug.cgi?id=29171
# https://mail.gnome.org/archives/gvfs-list/2013-May/msg00014.html
Patch1: gvfs-1.19.90-alt-1-logind-state.patch

%{?_enable_gdu:Obsoletes: gnome-mount <= 0.8}
%{?_enable_gdu:Obsoletes: gnome-mount-nautilus-properties <= 0.8}

# obsolete by %_bindir/gio from libgio
Obsoletes: %name-utils < 1.31
Obsoletes: bash-completion-gvfs < 1.31

%define glib_ver 2.57.2
%define libsoup_ver 2.42
%define avahi_ver 0.6
%define libcdio_paranoia_ver 10.2
%define bluez_ver 4.0
%define gdu_ver 3.3.91
%define udisks_ver 1.99
%define mtp_ver 1.1.5
%define goa_ver 3.17.1
%define libarchive_ver 3.0.22
%define imobiledevice_ver 1.1.5
%define nfs_ver 1.9.7
%define gdata_ver 0.17.3
%define libusb_ver 1.0.21

Requires: dconf
%{?_enable_fuse:Requires: fuse-gvfs}
%{?_enable_gdu:Requires: gnome-disk-utility >= %gdu_ver}
%{?_enable_udisks2:Requires: udisks2}

BuildRequires(pre): meson rpm-build-gnome rpm-build-licenses

BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libdbus-devel gtk-doc
BuildRequires: openssh-clients
# hotplug backend
BuildRequires: libgudev-devel
# required if autoreconf used
BuildRequires: libgcrypt-devel
%{?_enable_afc:BuildPreReq: libimobiledevice-devel >= %imobiledevice_ver}
%{?_enable_afp:BuildPreReq: libgcrypt-devel}
%{?_enable_archive:BuildPreReq: libarchive-devel >= %libarchive_ver}
%{?_enable_dnssd:BuildPreReq: libavahi-glib-devel >= %avahi_ver libavahi-devel >= %avahi_ver}
%{?_enable_bluray:BuildRequires: libbluray-devel}
%{?_enable_cdda:BuildPreReq: libcdio-paranoia-devel >= %libcdio_paranoia_ver}
%{?_enable_fuse:BuildPreReq: libfuse-devel}
%{?_enable_gcr:BuildRequires: gcr-libs-devel}
%{?_enable_gdu:BuildPreReq: libgdu-devel >= %gdu_ver libgudev-devel}
%{?_enable_goa:BuildPreReq: libgnome-online-accounts-devel >= %goa_ver}
%{?_enable_gphoto2:BuildPreReq: libgphoto2-devel}
%{?_enable_http:BuildPreReq: libsoup-devel >= %libsoup_ver libxml2-devel}
%{?_enable_keyring:BuildPreReq: libsecret-devel}
%{?_enable_libmtp:BuildPreReq: libmtp-devel >= %mtp_ver}
%{?_enable_nfs:BuildPreReq: libnfs-devel >= %nfs_ver}
%{?_enable_obexftp:BuildPreReq: libbluez-devel >= %bluez_ver libdbus-glib-devel libexpat-devel}
%{?_enable_samba:BuildPreReq: libsmbclient-devel}
%{?_enable_systemd_login:BuildPreReq: libsystemd-devel}
%{?_enable_udisks2:BuildPreReq: libudisks2-devel >= %udisks_ver}
%{?_enable_google:BuildPreReq: libgdata-devel >= %gdata_ver}
%{?_enable_admin:BuildRequires: libpolkit-devel libcap-devel}
%{?_enable_libusb:BuildRequires: libusb-devel >= %libusb_ver}

BuildPreReq: desktop-file-utils
BuildRequires: gcc-c++ perl-XML-Parser

# for check
#BuildRequires: /proc dbus-tools-gui python3 python3-module-pygobject3 python-module-twisted-core
#BuildRequires:  openssh-server apache2 samba genisoimage
# and more

%package devel
Summary: Libraries and include files for developing gvfs applications
Group: Development/GNOME and GTK+
BuildArch: noarch
Requires: %name = %version-%release

%package -n fuse-%name
Summary: gvfs fuse gateway
Group: System/Kernel and hardware
Requires: %name = %version-%release
Requires: %{get_dep fuse}

%package backend-smb
Summary: Samba backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release
Requires: samba-client

%package backend-obexftp
Summary: Obexftp backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release

%package backend-dnssd
Summary: Dnssd(avahi) backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release

%package backend-cdda
Summary: Music CD-ROM backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release

%package backend-afc
Summary: i{Phone,Pod} backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release

%package backend-afp
Summary: Apple Filing Protocol backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release

%package backend-recent-files
Summary: Recent files backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release

%package backend-goa
Summary: gnome-online-accounts backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release
Requires: gnome-online-accounts

%package backend-mtp
Summary: MTP support for gvfs
Group: System/Libraries
Requires: %name = %version-%release

%package backend-nfs
Summary: NFS backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release
Requires: nfs-clients
Requires(post): libcap-utils

%package backend-google
Summary: Google drive backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release
Requires: gnome-online-accounts

%package backend-admin
Summary: Admin backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release
Requires: polkit

%package backends
Summary: All backends for gvfs
Group: System/Libraries
BuildArch: noarch
Requires: gvfs gvfs-backend-smb gvfs-backend-dnssd
Requires: gvfs-backend-recent-files
%{?_enable_cdda:Requires: gvfs-backend-cdda}
%{?_enable_obexftp:Requires: gvfs-backend-obexftp}
%{?_enable_afc:Requires: gvfs-backend-afc}
%{?_enable_afp:Requires: gvfs-backend-afp}
%{?_enable_goa:Requires: gvfs-backend-goa}
%{?_enable_libmtp:Requires: gvfs-backend-mtp}
%{?_enable_nfs:Requires: gvfs-backend-nfs}
%{?_enable_google:Requires: gvfs-backend-google}
%{?_enable_admin:Requires: gvfs-backend-admin}

%description
gvfs is a userspace virtual filesystem where mount runs as a separate
processes which you talk to via dbus. It also contains a gio module that
seamlessly adds gvfs support to all applications using the gio API. It also
supports exposing the gvfs mounts to non-gio applications using fuse.

This package contains the gvfs server, libgvfscommon library, gio
modules and backends for gvfs: archive, burn, computer, dav, ftp,
gphoto2, http, localtest, network, sftp and trash.

%description devel
gvfs is a userspace virtual filesystem where mount runs as a separate
processes which you talk to via dbus. It also contains a gio module that
seamlessly adds gvfs support to all applications using the gio API. It also
supports exposing the gvfs mounts to non-gio applications using fuse.

This package contains the libgvfscommon development files.

%description -n fuse-%name
fuse-gvfs is a bridge between the gvfs filesystem design and fuse, a
program to mount user-space filesystems.

%description backend-smb
This package contains the smb and smb-browse backends for gvfs.

%description backend-obexftp
This package contains the obexftp backend for gvfs.

%description backend-dnssd
This package contains the dnssd backend for gvfs.

%description backend-cdda
This package contains the cdda backend for gvfs.

%description backend-afc
This package contains a backend for gvfs, providing access to Apple's
iPhone, and iPod Touch devices.

%description backend-afp
This package contains a backend for gvfs, providing access to Apple
Mac OS X filesystem by AFP (Apple Filing Protocol) network protocol.

%description backend-recent-files
This package contains recent files backend for gvfs.

%description backend-goa
This package contains gnome-online-accounts backend for gvfs.

%description backend-mtp
This package provides support for reading and writing files on MTP based
devices (Media Transfer Protocol) to applications using gvfs.

%description backend-nfs
This package provides support for mounting NFS shares using gvfs.

%description backend-google
This package provides support for mounting google drive using gvfs.

%description backend-admin
This package provides admin backend for gvfs based on polkit.

%description backends
This virtual package contains the all backends for gvfs.

%package tests
Summary: GVFS test programms
Group: Development/GNOME and GTK+
BuildArch: noarch
Requires: %name-backends = %version-%release fuse-%name

%description tests
The %name-tests package provides programms for testing GVFS.

%define _libexecdir %_prefix/libexec/%name

%prep
%setup
#%%patch1 -p2 -b .logind-state

%build
%meson \
        %{?_enable_http:-Dhttp=true} \
        %{?_enable_dnssd:-Ddnssd=true} \
        %{?_enable_cdda:-Dcdda=true} \
        %{?_enable_fuse:-Dfuse=true} \
        %{?_enable_gphoto2:-Dgphoto2=true} \
        %{?_enable_keyring:-Dkeyring=true} \
        %{?_enable_samba:-Dsmb=true} \
        %{?_enable_archive:-Darchive=true} \
        %{?_enable_afc:-Dafc=true} \
        %{?_enable_afp:-Dafp=true} \
        %{?_enable_gdu:-Dgdu=true} \
        %{?_enable_udisks2:-Dudisks2=true} \
        %{?_enable_libmtp:-Dmtp=true} \
        %{?_enable_bluray:-Dbluray=true} \
        %{?_enable_nfs:-Dnfs=true} \
        %{?_enable_google:-Dgoogle=true} \
        %{?_enable_libusb:-Dlibusb=true} \
        %{?_enable_systemd_login:-Dlogind=true} \
        %{?_enable_gtk_doc:-Dgtk_doc=true} \
        %{?_enable_man:-Dman=true} \
        %{?_enable_installed_tests:-Dinstalled_tests=true}
%meson_build

%install
%meson_install
%find_lang %name

%check
export PATH=/usr/sbin:$PATH
%meson_test

%post
killall -USR1 gvfsd >&/dev/null || :

%post backend-nfs
# for privileged ports
setcap -q cap_net_bind_service=ep %_libexecdir/gvfsd-nfs ||:


%files -f %name.lang
%doc NEWS README* monitor/udisks2/what-is-shown.txt
%dir %_libdir/%name
%_libdir/%name/libgvfs*.so
%dir %_libexecdir
# daemon
%_libexecdir/gvfsd
%config %_datadir/glib-2.0/schemas/org.gnome.system.gvfs.enums.xml
%_prefix/lib/systemd/user/gvfs-daemon.service
%_prefix/lib/systemd/user/gvfs-metadata.service
# monitors
%_libexecdir/gvfs-gphoto2-volume-monitor
%_prefix/lib/systemd/user/gvfs-gphoto2-volume-monitor.service
%{?_enable_gdu:%_libexecdir/gvfs-gdu-volume-monitor}
%{?_enable_udisks2:%_libexecdir/gvfs-udisks2-volume-monitor}
%{?_enable_udisks2:%_prefix/lib/systemd/user/gvfs-udisks2-volume-monitor.service}
%_datadir/dbus-1/services/*
# gio modules
%_libdir/gio/modules/*.so
# default backends
%_libexecdir/gvfsd-*

%exclude %_libexecdir/gvfsd-fuse

%dir %_datadir/%name
%dir %_datadir/%name/remote-volume-monitors
%_datadir/%name/remote-volume-monitors/gphoto2.monitor
%{?_enable_gdu:%_datadir/%name/remote-volume-monitors/gdu.monitor}
%{?_enable_udisks2:%_datadir/%name/remote-volume-monitors/udisks2.monitor}

%_datadir/%name/mounts

%if_enabled man
%_man1dir/gvfsd-fuse.1.*
%_man1dir/gvfsd-metadata.1.*
%_man1dir/gvfsd.1.*
%_man7dir/gvfs.7.*
%endif

# in another packages
%exclude %_libexecdir/gvfsd-recent
%exclude %_datadir/%name/mounts/recent.mount

%if_enabled samba
    %exclude %_libexecdir/gvfsd-smb
    %exclude %_libexecdir/gvfsd-smb-browse
    %exclude %_datadir/%name/mounts/smb.mount
    %exclude %_datadir/%name/mounts/smb-browse.mount
%endif

%{?_enable_cdda:%exclude %_libexecdir/gvfsd-cdda}

%if_enabled obexftp
    %exclude %_libexecdir/gvfsd-obexftp
    %exclude %_datadir/%name/mounts/obexftp.mount
%endif

%if_enabled afc
    %exclude %_libexecdir/gvfsd-afc
    %exclude %_datadir/%name/mounts/afc.mount
%endif

%if_enabled afp
    %exclude %_libexecdir/gvfsd-afp
    %exclude %_libexecdir/gvfsd-afp-browse
    %exclude %_datadir/%name/mounts/afp.mount
    %exclude %_datadir/%name/mounts/afp-browse.mount
%endif

%{?_enable_cdda:%exclude %_datadir/%name/mounts/cdda.mount}
%{?_enable_dnssd:%exclude %_libexecdir/gvfsd-dnssd}
%{?_enable_dnssd:%exclude %_datadir/%name/mounts/dns-sd.mount}

%if_enabled libmtp
    %exclude %_libexecdir/gvfsd-mtp
    %exclude %_datadir/%name/mounts/mtp.mount
    %exclude %_datadir/dbus-1/services/org.gtk.vfs.MTPVolumeMonitor.service
%endif

%if_enabled nfs
    %exclude %_libexecdir/gvfsd-nfs
    %exclude %_datadir/%name/mounts/nfs.mount
%endif

%if_enabled google
    %exclude %_libexecdir/gvfsd-google
    %exclude %_datadir/%name/mounts/google.mount
%endif

%if_enabled admin
    %exclude %_libexecdir/gvfsd-admin
    %exclude %_datadir/%name/mounts/admin.mount
%endif

%files devel
%_includedir/*

%files -n fuse-%name
%_libexecdir/gvfsd-fuse
/lib/tmpfiles.d/gvfsd-fuse-tmpfiles.conf

%files backend-smb
%_libexecdir/gvfsd-smb
%_libexecdir/gvfsd-smb-browse
%_datadir/%name/mounts/smb.mount
%_datadir/%name/mounts/smb-browse.mount
%config %_datadir/glib-2.0/schemas/org.gnome.system.smb.gschema.xml
%_datadir/GConf/gsettings/gvfs-smb.convert

%if_enabled obexftp
%files backend-obexftp
%_libexecdir/gvfsd-obexftp
%_datadir/%name/mounts/obexftp.mount
%endif

%if_enabled dnssd
%files backend-dnssd
%_libexecdir/gvfsd-dnssd
%_datadir/%name/mounts/dns-sd.mount
%config %_datadir/glib-2.0/schemas/org.gnome.system.dns_sd.gschema.xml
%_datadir/GConf/gsettings/gvfs-dns-sd.convert
%endif

%if_enabled cdda
%files backend-cdda
%_libexecdir/gvfsd-cdda
%_datadir/%name/mounts/cdda.mount
%endif

%if_enabled afc
%files backend-afc
%_libexecdir/gvfsd-afc
%_libexecdir/gvfs-afc-volume-monitor
%_datadir/%name/mounts/afc.mount
%_datadir/%name/remote-volume-monitors/afc.monitor
%_prefix/lib/systemd/user/gvfs-afc-volume-monitor.service
%endif

%if_enabled afp
%files backend-afp
%_libexecdir/gvfsd-afp
%_libexecdir/gvfsd-afp-browse
%_datadir/%name/mounts/afp.mount
%_datadir/%name/mounts/afp-browse.mount
%endif

%files backend-recent-files
%_libexecdir/gvfsd-recent
%_datadir/%name/mounts/recent.mount

%if_enabled goa
%files backend-goa
%_libexecdir/%name-goa-volume-monitor
%_datadir/%name/remote-volume-monitors/goa.monitor
%_prefix/lib/systemd/user/gvfs-goa-volume-monitor.service
%endif

%if_enabled libmtp
%files backend-mtp
%_libexecdir/gvfsd-mtp
%_libexecdir/gvfs-mtp-volume-monitor
%_datadir/%name/mounts/mtp.mount
%_datadir/%name/remote-volume-monitors/mtp.monitor
%_datadir/dbus-1/services/org.gtk.vfs.MTPVolumeMonitor.service
%_prefix/lib/systemd/user/gvfs-mtp-volume-monitor.service
%endif

%if_enabled nfs
%files backend-nfs
%_libexecdir/gvfsd-nfs
%_datadir/%name/mounts/nfs.mount
%endif

%if_enabled google
%files backend-google
%_libexecdir/gvfsd-google
%_datadir/%name/mounts/google.mount
%endif

%if_enabled admin
%files backend-admin
%_libexecdir/gvfsd-admin
%_datadir/%name/mounts/admin.mount
%_datadir/polkit-1/actions/org.gtk.vfs.file-operations.policy
%_datadir/polkit-1/rules.d/org.gtk.vfs.file-operations.rules
%endif

%files backends

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/
%_datadir/installed-tests/%name/
%endif


%changelog
