Epoch: 0
Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-java
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           htmlunit
Version:        2.23
Release:        alt1_6jpp8
Summary:        A headless web browser for automated testing
License:        ASL 2.0 
URL:            http://htmlunit.sourceforge.net/
# Source0:        http://downloads.sourceforge.net/htmlunit/%%{name}-%%{version}-src.zip
# Steps for generate the archive:
# svn export http://svn.code.sf.net/p/htmlunit/code/tags/HtmlUnit-2.23/  htmlunit-2.23
# Cleanup, remove unused test resources (taraball become more lightweight: 60MB >> 24MB)
# find htmlunit-2.23 -name '*.jar' -print -delete
# find htmlunit-2.23 -name '*.js' -print -delete 
# find htmlunit-2.23 -name '*.class' -print -delete
# find htmlunit-2.23 -name '*.dll' -print -delete
# find htmlunit-2.23 -name '*.exe' -print -delete
# find htmlunit-2.23 -name '*.gz' -print -delete
# find htmlunit-2.23 -name 'php-cgi*' -print -delete
# rm -rf htmlunit-2.23/src/test/resources/libraries
# rm -rf htmlunit-2.23/src/test/resources/pjl-comp-filter
# tar cJf htmlunit-2.23.tar.xz htmlunit-2.23

Source0:        %{name}-%{version}.tar.xz
# javascript not allowed in javadoc
Patch0:         htmlunit-2.23-javascript.patch

BuildRequires:  maven-local
BuildRequires:  mvn(commons-codec:commons-codec)
BuildRequires:  mvn(commons-collections:commons-collections)
BuildRequires:  mvn(commons-io:commons-io)
BuildRequires:  mvn(commons-logging:commons-logging)
BuildRequires:  mvn(net.sourceforge.cssparser:cssparser)
BuildRequires:  mvn(net.sourceforge.htmlunit:htmlunit-core-js)
BuildRequires:  mvn(net.sourceforge.htmlunit:neko-htmlunit)
BuildRequires:  mvn(org.apache.commons:commons-lang3)
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires:  mvn(org.apache.httpcomponents:httpclient)
BuildRequires:  mvn(org.apache.httpcomponents:httpmime)
BuildRequires:  mvn(org.apache.maven.plugins:maven-enforcer-plugin)
BuildRequires:  mvn(org.eclipse.jetty.websocket:websocket-client)
BuildRequires:  mvn(xalan:xalan)
BuildRequires:  mvn(xalan:xsltc)
BuildRequires:  mvn(xerces:xercesImpl)

BuildArch:      noarch
Source44: import.info

%description
HtmlUnit is a "GUI-Less browser for Java programs". It models HTML 
documents and provides an API for automated testing of
web applications. 

%package javadoc
Group: Development/Java
Summary:        API documentation for %{name}
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.

%prep
%setup -q
#find -name '*.jar' -print -delete 
#find -name '*.class' -print -delete

%patch0 -p1

%pom_xpath_remove "pom:build/pom:extensions"

%pom_xpath_set "pom:packaging" bundle
%pom_xpath_remove "pom:Embed-Dependency"

# unwanted plugin
%pom_remove_plugin :maven-assembly-plugin
%pom_remove_plugin :maven-eclipse-plugin
%pom_remove_plugin :maven-gpg-plugin
%pom_remove_plugin :maven-scm-plugin
%pom_remove_plugin :maven-site-plugin
%pom_remove_plugin :maven-source-plugin

# Unavailable test deps
%pom_remove_dep org.seleniumhq.selenium:
%pom_xpath_remove "pom:dependency[pom:type = 'test-jar']"
# org.apache.httpcomponents:httpclient:4.1.2:test-jar
%pom_xpath_remove "pom:project/pom:dependencies/pom:dependency[pom:scope = 'test']"

%pom_add_dep xalan:xsltc:2.7.1

%mvn_file : %{name}

%build

# enabling tests would require packaging some selenium plugins
%mvn_build -f

%install
%mvn_install

%files -f .mfiles
%doc --no-dereference LICENSE.txt

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE.txt

%changelog
