Name: ifplugd
Version: 0.28
Release: alt5

Summary: Detect and perform actions when an ethernet cable is (un)plugged
License: GPL
Group: System/Configuration/Networking

Url: http://0pointer.de/lennart/projects/ifplugd/
Source0: %url/%name-%version.tar.gz
Source1: %name.init
Patch0:	ifplugd-0.28-alt-etcnet.patch
Patch1:	ifplugd-0.28-interface.patch

Packager: Denis Ovsienko <pilot@altlinux.ru>

BuildRequires: gcc-c++ hostinfo libdaemon-devel >= 0.4 mailcap pkgconfig
Requires: libdaemon service coreutils util-linux network-config-subsystem

Summary(ru_RU.UTF-8): Конфигурирование сетевого интерфейса при наличии кабеля

%description
%name is a service which will automatically configure your ethernet device
when a cable is plugged in and automatically unconfigure it if the cable is
pulled.

This is useful on laptops with onboard network adapters, since it will only
configure the interface when a cable is really connected.

NB: not every Linux ethernet driver is capable of reporting link status.
Use ifplugstatus to find out.

%description -l ru_RU.UTF-8
%name -- сервис, отвечающий за автоматическое конфигурирование сетевого
интерфейса при подключении кабеля и деактивацию -- при отключении.

Полезен на ноутбуках с сетевыми картами, т.к. при этом интерфейс будет
активирован только при включении сетевого кабеля.

NB: не каждый драйвер Ethernet в Linux выдаёт статус линка.
Используйте ifplugstatus, чтобы выяснить это.

%prep
%setup
%patch0 -p1
%patch1 -p0
sed -i 's@/usr/local@@' man/*.[58]

%build
%configure \
	--sbindir=%_sbindir \
	--disable-lynx \
	--disable-xmltoman \
	--disable-subversion
%make

%install
sed -i 's,^ARGS="-,&q,' conf/ifplugd.conf
%makeinstall sysinitdir=%buildroot%_initdir
install -pDm755 %SOURCE1 %buildroot%_initdir/%name

%post
%post_service ifplugd

%preun
%preun_service ifplugd

%files
%doc doc/README doc/README.html
%doc doc/NEWS doc/SUPPORTED_DRIVERS doc/style.css
%_sbindir/*
%_initdir/*
%_mandir/*/*
%dir %_sysconfdir/ifplugd/
%config(noreplace) %_sysconfdir/ifplugd/ifplugd.conf
%config(noreplace) %_sysconfdir/ifplugd/ifplugd.action

# TODO:
# - import Debian's apm script (suspend/resume ifplugd)

%changelog
