%define major 1.0
%define pre beta1

%def_without gnome_vfs
%def_without dbus
%def_disable check
%def_disable test

Name: inkscape
Version: %major.1
Release: alt4

Summary: A Vector Drawing Application

License: GPL
Group: Graphics
Url: http://inkscape.org

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://media.inkscape.org/dl/resources/file/inkscape-%version.tar.xz
Source: %name-%version.tar

Patch: %name-dia.patch
Patch6: fix_atomic_rel_error.patch

# Typical environment for GTK program
Requires(post,postun): desktop-file-utils
BuildPreReq: desktop-file-utils

AutoProv:yes,nopython3
BuildRequires(pre): rpm-build-python3
%add_python3_lib_path %_datadir/%name/extensions

BuildRequires: boost-devel-headers cmake gcc-c++ intltool
BuildRequires: libgc-devel libgsl-devel libpopt-devel libxslt-devel perl-devel zlib-devel libsoup-devel libaspell-devel libdbus-devel

# Checking for modules 'gtkmm-3.0>=3.22;gdkmm-3.0>=3.22;gtk+-3.0>=3.22;gdk-3.0>=3.22;gdl-3.0>=3.4'
BuildRequires: libgtkmm3-devel >= 3.22 libgdl3-devel >= 3.4

%{?_with_gnome_vfs:BuildRequires: gnome-vfs-devel}
%{?_with_dbus: BuildRequires: libdbus-devel}
BuildRequires: libwpg-devel librevenge-devel libcdr-devel libvisio-devel
BuildRequires: libpng-devel libexif-devel libjpeg-devel libImageMagick-devel
BuildRequires: libpoppler-devel libpoppler-glib-devel
BuildRequires: libpotrace-devel liblcms2-devel
%ifnarch %e2k
# lcc has -lomp, not -lgomp
BuildRequires: libgomp-devel
%endif
BuildRequires: libdouble-conversion-devel
BuildRequires: perl-podlators
Requires: icc-profiles

# For extensions
# https://bugzilla.altlinux.org/21626
Requires: wmf-utils
# Recommends: skencil pstoedit

# mike: work around https://bugzilla.altlinux.org/24586
Requires: gnome-icon-theme

# TODO
#Requires: inkscape-data = %EVR
Requires: inkscape-tutorial

%description
Inkscape is a SVG based generic vector-drawing program for Linux/Unix
and Windows.  It uses an advanced imaging engine with anti-aliased
display, alpha transparency, and vector fonts.

%description -l ru_RU.UTF-8
Inkscape -- это программа векторного рисования общего назначения,
использующая формат SVG, работающая на платформах Linux/Unix/Windows
и имеющая мощный движок для отображения графики со сглаживанием,
альфа-каналом и векторными шрифтами.

%package viewer
Summary: Viewer for Inkscape files
Group: Graphics

%description viewer
inkview is standalone viewer for Inkscape files (SVG).

# TODO: move /usr/share/inkscape to data package?
%package data
Summary: Inkscape data files
Group: Graphics
BuildArch: noarch

%description data
Inkview tutorial.


%package tutorial
Summary: Inkscape tutorial
Group: Graphics
BuildArch: noarch

%description tutorial
Inkview tutorial.

%package checkinstall
Summary: Checkinstall for %name
Group: Development/Other
BuildArch: noarch
#Requires(pre): %name = %EVR
Conflicts: python3(setuptools)

%description checkinstall
Run checkinstall tests for %name.

%prep
%setup
%patch6 -p1

%build
%cmake_insource -DBUILD_SHARED_LIBS=off
# FIXME: ppc64le (make -j132):
# No rule to make target 'po/bn.gmo', needed by 'share/templates/default_templates.timestamp
%make_build || %make_build -j2

%install
%makeinstall_std

rm -rf %buildroot%_docdir/inkscape/
# remove unneeded man
rm -rf %buildroot%_mandir/??/
rm -rf %buildroot%_mandir/??_??/

subst "s|/usr/bin/env python$|%__python3|" %buildroot%_datadir/%name/extensions/*.py

# remove tests
rm -rf %buildroot%_datadir/%name/extensions/tests/
rm -rf %buildroot%_datadir/%name/extensions/inkex/tester/
rm -rf %buildroot%_datadir/%name/extensions/{setup.py,setup.cfg}

%find_lang %name

%check
$(INKSCAPE) -z -f $< --export-eps=$@
$(INKSCAPE) -z -f $< --export-png=$@
true

%files -f %name.lang
%doc AUTHORS CONTRIBUTING.md NEWS.md COPYING README.md doc
%_bindir/inkscape
#_libdir/libinkscape_base.so
%_datadir/%name/
%exclude %_datadir/inkscape/tutorials/
#_datadir/appdata/inkscape*
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/*.png
%_man1dir/inkscape*
#_mandir/??/man1/inkscape.??.1.*
%_datadir/metainfo/org.inkscape.Inkscape.appdata.xml

%files viewer
%_bindir/inkview
%_man1dir/inkview*

%files tutorial
%_datadir/inkscape/tutorials/

%files checkinstall

%changelog
