%def_disable german
Name: ispell
Version: 3.2.06
Release: alt14
Epoch: 1

Summary: The GNU interactive spelling checker program
License: BSD-like
Packager: Igor Vlasenko <viy@altlinux.ru>
Group: Text tools
URL: http://ficus-www.cs.ucla.edu/ficus-members/geoff/ispell.html

Source0: http://fmg-www.cs.ucla.edu/geoff/tars/ispell-%version.tar
Source2: spell
Source3: ispell-3.20-hk2-deutsch.tar

Patch0: ispell-3.1.20-config.patch
Patch1: ispell-3.2.06-german.patch
Patch2: ispell-3.1.20-termio.patch
Patch3: ispell-3.1.20-strcmp.patch
Patch4: ispell-3.1.20-maskbits64_and_british.patch
Patch5: ispell-3.2.06-dont-string.patch
Patch6: ispell-3.20-sh.patch
Patch7: ispell-3.20-missing_prototypes.patch
Patch8: ispell-3.20-increase-max.patch
Patch9: ispell-3.20-xb-options.patch
Patch10: ispell-3.2.06-sq.patch
Patch11: ispell-3.20-man-update.patch
# add missing includes
Patch12: ispell-3.2.06-includes.patch
# use mkdir -p to create directories
Patch13: ispell-3.2.06-mkdir_p.patch
# fix syntax error
Patch14: ispell-3.2.06-syntax.patch

Patch15: ispell-3.2.06-alt-downgrade-english-wordchars.patch
Patch16: ispell-3.2.06-epa7-tmp.patch
Patch17: ispell-3.2.06.epa7-alt-tmp.patch

Patch18: ispell-3.2.06-alt-fix-munchlist.patch
Patch19: ispell-3.2.06-alt-gcc44-system-getline.patch

PreReq: alternatives >= 0:0.3.0
Requires: mktemp >= 1:1.3.1
Provides: /usr/bin/spell

# Automatically added by buildreq on Mon Jun 26 2006
BuildRequires: alternatives libtinfo-devel words

BuildPreReq: alternatives >= 0:0.3.0

%description
Ispell is the GNU interactive spelling checker.  Ispell will check a text
file for spelling and typographical errors.  When it finds a word that is
not in the dictionary, it will suggest correctly spelled words for the
misspelled word.

Note this package has only the spell checker engine; you also need to
install the dictionary files from the ispell-* package for your language.

%package en
Summary: English dictionary for ispell
Group: Text tools
# the binary format changed with ispell 3.2.06
Requires: ispell >= 1:3.2.06
BuildPreReq: words >= 2
Obsoletes: iamerica ispell-english ibritish ispell-british
Provides: ispell-dictionary = 3.2.06

%description en
This package has the English dictionary files for ispell.

With it you can check the spelling of Enlish text files or LaTeX files
written in English.

%package de
Summary: German dictionary for ispell
Group: System/Internationalization
Requires: ispell >= 1:3.2.06
Obsoletes: ispell-german igerman
Provides: ispell-dictionary = 3.2.06

%description de
This package has the German dictionary files for ispell.

%prep
%setup -q -a3

%patch0 -p1
%patch1
%patch2 -p1 -b .termio
%patch3 -p1 -b .strcmp
%patch4 -p1 -b .maskbits
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1 -b .SQ
#%patch11 -p1
%patch12 -p1 -b .includes
%patch13 -p1 -b .mkdir-p
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p0
%patch19 -p1

%build
cat >>./local.h <<\__EOF__
#define CC "gcc"
#define CFLAGS "%optflags"
#define BINDIR "%_bindir"
#define LIBDIR "%_libdir/%name"
#define MAN1DIR "%_man1dir"
#define MAN4DIR "%_man4dir"	/* for upstream releases */
#define MANFDIR "%_man5dir"	/* for unofficial `epa' releases */
#define INSTALL "install -p"
#define MASTERHASH "americanmed+.hash"
#define TERMLIB "-ltinfo"
__EOF__
subst s,/usr/dict/words,%_datadir/dict/words,g local.h

# Make sure that the mtime of files generated during the build
# (especially config.sh) is not in the same second as local.h.
sleep 2

# SMP-incompatible build
%make

%install
# This 'subst' invocation modifies config.sh, which is generated from
# local.h; the following 'make' call must not rebuild config.sh,
# otherwise install will fail.  The '-p' option is also required to
# avoid rebuild of programs (which otherwise may get wrong compiled-in
# paths).  However, 'subst -p' currently does not support sub-second
# timestamps - it silently truncates them to the start of the second,
# therefore config.sh mtime goes backwards and might go before the
# local.h mtime, and in this case make will rebuild config.sh.  The
# 'sleep 2' above works around this problem.
subst -p 's,%_prefix,%buildroot&,g' config.sh

%makeinstall
mv %buildroot%_bindir/ispell %buildroot%_bindir/ispell-real
install -pD %SOURCE2 %buildroot%_bindir/ispell-spell
install -d %buildroot%_altdir
cat > %buildroot%_altdir/%name <<'EOF'
/usr/bin/ispell	/usr/bin/ispell-real	40
EOF
cat > %buildroot%_altdir/%name-spell <<'EOF'
/usr/bin/spell	/usr/bin/ispell-spell	40
EOF

%files
%doc README
%attr(755,root,root) %_bindir/*
%_altdir/%{name}*
%_man1dir/ispell.1*
%_man4dir/ispell.4*
#_infodir/ispell.info*
#_libdir/emacs/site-lisp/ispell.el
%_man1dir/buildhash.1*
%_man1dir/munchlist.1*
%_man1dir/findaffix.1*
%_man1dir/tryaffix.1*
%_man1dir/sq.1*
%_man1dir/unsq.1*
%dir %_libdir/%name

%files en
%_man4dir/english.4*
%_libdir/%name/american.hash
%_libdir/%name/americanmed+.hash
%_libdir/%name/americanxlg.hash
%_libdir/%name/english.aff
%_libdir/%name/english.hash
%_libdir/%name/british.hash
%_libdir/%name/britishmed+.hash
%_libdir/%name/britishxlg.hash

%if_enabled german
%files de
%_libdir/%name/deutsch.aff
%_libdir/%name/deutsch.hash
%_libdir/%name/deutschlxg.hash
%_libdir/%name/deutschmed.hash
%_libdir/%name/german.hash
%endif

%changelog
