%define module_name	virtualbox-addition
%define module_version  6.1.26
%define module_release	alt1

%define flavour		un-def
%define karch x86_64 %ix86
BuildRequires(pre): rpm-build-kernel >= 0.100-alt1
BuildRequires(pre): kernel-headers-modules-un-def

%setup_kernel_module %flavour

%define module_dir /lib/modules/%kversion-%flavour-%krelease/misc

%define guest_module_name	vboxguest
%define vfs_module_name		vboxsf
%define video_module_name	vboxvideo

Summary: VirtualBox modules
Name: kernel-modules-%module_name-%flavour
Version: %module_version
Release: %module_release.%kcode.%kbuildrelease
License: GPLv2
Group: System/Kernel and hardware

Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>

ExclusiveOS: Linux
Url: http://www.virtualbox.org/

Patch0: vboxcommon-5.4.patch

BuildPreReq: gcc-c++
BuildRequires: perl
BuildRequires: rpm >= 4.0.2-75
BuildRequires: kernel-headers-modules-%flavour = %kepoch%kversion-%krelease
BuildRequires: kernel-source-%guest_module_name = %module_version
BuildRequires: kernel-source-%vfs_module_name = %module_version
BuildRequires: kernel-source-%video_module_name = %module_version

Provides: kernel-modules-%module_name-%kversion-%flavour-%krelease = %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease < %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease > %version-%release

Provides: kernel-modules-%vfs_module_name-%kversion-%flavour-%krelease = %version-%release
Provides: kernel-modules-%vfs_module_name-%flavour = %version-%release
Obsoletes: kernel-modules-%vfs_module_name-%flavour < %version-%release

PreReq: kernel-image-%flavour = %kepoch%kversion-%krelease
ExclusiveArch: %karch

Requires: virtualbox-guest-common
Requires: kernel-modules-%module_name-video-%flavour = %version-%release
Requires: kernel-modules-%module_name-guest-%flavour = %version-%release
Requires: virtualbox-guest-common-vboxsf

%description
This package contains VirtualBox addition modules (vboxguest, vboxsf)
that are needed for additonal guests support for VirtualBox.


%package -n kernel-modules-%module_name-video-%flavour
Summary: VirtualBox video modules
Version: %module_version
Release: %module_release.%kcode.%kbuildrelease
PreReq: kernel-image-%flavour = %kepoch%kversion-%krelease
License: GPLv2
Group: System/Kernel and hardware

Provides: kernel-modules-%module_name-video-%kversion-%flavour-%krelease = %version-%release
Conflicts: kernel-modules-%module_name-video-%kversion-%flavour-%krelease < %version-%release
Conflicts: kernel-modules-%module_name-video-%kversion-%flavour-%krelease > %version-%release

Provides: kernel-modules-%video_module_name-%kversion-%flavour-%krelease = %version-%release
Provides: kernel-modules-%video_module_name-%flavour = %version-%release

Requires: virtualbox-guest-common-vboxvideo

%description -n kernel-modules-%module_name-video-%flavour
This package contains VirtualBox addition vboxvideo module
that are needed for additonal guests support for VirtualBox.
You can also use vboxvideo module from staging subpackage of
your kernel.


%package -n kernel-modules-%module_name-guest-%flavour
Summary: VirtualBox guest modules
Version: %module_version
Release: %module_release.%kcode.%kbuildrelease
PreReq: kernel-image-%flavour = %kepoch%kversion-%krelease
License: GPLv2
Group: System/Kernel and hardware

Provides: kernel-modules-%module_name-guest-%kversion-%flavour-%krelease = %version-%release
Conflicts: kernel-modules-%module_name-guest-%kversion-%flavour-%krelease < %version-%release
Conflicts: kernel-modules-%module_name-guest-%kversion-%flavour-%krelease > %version-%release

Provides: kernel-modules-%guest_module_name-%kversion-%flavour-%krelease = %version-%release
Provides: kernel-modules-%guest_module_name-%flavour = %version-%release

Requires: virtualbox-guest-common-vboxguest

%description -n kernel-modules-%module_name-guest-%flavour
This package contains VirtualBox addition vboxvideo module
that are needed for additonal guests support for VirtualBox.
You can also use vboxvideo module from staging subpackage of
your kernel.


%prep
%setup -T -c -n kernel-source-%module_name-%module_version
tar jxvf %kernel_src/kernel-source-%guest_module_name-%module_version.tar.bz2
pushd kernel-source-%guest_module_name-%module_version
%patch0 -p1
popd
tar jxvf %kernel_src/kernel-source-%vfs_module_name-%module_version.tar.bz2
pushd kernel-source-%vfs_module_name-%module_version
%patch0 -p1
popd
tar jxvf %kernel_src/kernel-source-%video_module_name-%module_version.tar.bz2

%build
. %_usrsrc/linux-%kversion-%flavour/gcc_version.inc
%make -C kernel-source-%guest_module_name-%module_version \
    KERN_DIR=%_usrsrc/linux-%kversion-%flavour/ KERN_VER=%kversion
%make -C kernel-source-%vfs_module_name-%module_version \
    KERN_DIR=%_usrsrc/linux-%kversion-%flavour/ KERN_VER=%kversion \
    KBUILD_EXTRA_SYMBOLS=%_builddir/kernel-source-%module_name-%module_version/kernel-source-%guest_module_name-%module_version/Module.symvers
%make -C kernel-source-%video_module_name-%module_version \
    KERN_DIR=%_usrsrc/linux-%kversion-%flavour/ KERN_VER=%kversion

%install
mkdir -p %buildroot/%module_dir
install -pD -m644 kernel-source-%guest_module_name-%module_version/vboxguest.ko \
    %buildroot%module_dir/vboxguestvbox.ko
install -pD -m644 kernel-source-%vfs_module_name-%module_version/vboxsf.ko \
    %buildroot%module_dir/vboxsfvbox.ko
install -pD -m644 kernel-source-%video_module_name-%module_version/vboxvideo.ko \
    %buildroot%module_dir/vboxvideovbox.ko

%files
%defattr(644,root,root,755)
%module_dir/vboxsfvbox.ko
%exclude %module_dir/vboxvideovbox.ko
%exclude %module_dir/vboxguestvbox.ko

%files -n kernel-modules-%module_name-guest-%flavour
%module_dir/vboxguestvbox.ko

%files -n kernel-modules-%module_name-video-%flavour
%module_dir/vboxvideovbox.ko

%changelog
