%def_without quicktime

Name: kino
Version: 1.3.4
Release: alt10

Summary: Non-linear DV editor
Group: Video
License: GPL

Url: http://www.kinodv.org
Source: http://dl.sf.net/%name/%name-%version.tar.gz
Source1: %name-48x48.xpm
Source2: %name-32x32.xpm
Source3: %name-16x16.xpm
Source4: Kino.desktop
Source5: kino-1.3.4-ru.po.bz2
Patch1: kino-1.3.4-alt-alsa-default.patch
Patch2: kino-1.3.4-alt-makefile-libxml2.patch
Patch3: kino-1.3.4-v4l1.patch
Patch4: ffmpeg2dirac-optional.patch

Packager: Michael Shigorin <mike@altlinux.org>

%define desktop_file_utils_ver 0.8

Requires(post,postun): desktop-file-utils >= %desktop_file_utils_ver
Requires(post,postun): shared-mime-info >= 0.15-alt2

BuildPreReq: desktop-file-utils >= %desktop_file_utils_ver

%if_with quicktime
BuildPreReq: libquicktime-devel >= 0.9.7-alt4
%endif

BuildRequires: gcc-c++ imake libSM-devel libXext-devel libXv-devel libalsa-devel libavc1394-devel libdv-devel libglade-devel libiec61883-devel libsamplerate-devel xorg-cf-files libavformat-devel liblame-devel perl-XML-Parser liba52-devel xorg-xextproto-devel libxml2-devel
BuildRequires: libdc1394-devel libv4l-devel libgsm-devel

%description
Kino is a non-linear DV editor for GNU/Linux. It features excellent
integration with IEEE 1394 for capture, VTR control, and recording back
to the camera. It captures video to disk in AVI format in both type-1 DV
and type-2 DV (separate audio stream) encodings.

You can load multiple video clips into a playlist, cut and paste
portions of video/audio, and save it to a playlist. Most edit and
navigation commands are mapped to equivalent vi key commands. Also, Kino
can load playlists and  save the composite playlist as a new DV AVI
file. Finally, Kino can save a single frame of video (a still) in
numerous file formats (based upon file extension).

Currently, Kino does not support other video file formats or encodings.
It does not support multiple layers or tracks of video and audio. It
does not do image processing, titling, transitions, or effects. We plan
to implement most of these features, but first we chose to focus on the
basics of IEEE 1394, video, audio, and file input and output. We place a
lot of emphasis on quality, stability, performance, and workflow.

For more information, please read the NEWS file, which contains
functional changes and important notices for each new version. The
ChangeLog contains a more detailed, technical account of the changes in
each version. Valuable information is contained in these files unless
you can read C/C++ source  code. Also, the discussion forums on the user
website above are very helpful.

%package devel
Group: Development/C++
Summary: Header files for kino plugin development
Requires: %name = %version-%release
BuildArch: noarch

%description devel
This package contains the headers files needed to build extensions for kino.

%package dvdauthor
Group: Video
Summary: K3B/dvdauthor integration
Requires: k3b qdvdauthor dvd+rw-tools
BuildArch: noarch

%description dvdauthor
This package contains optional scripts to be able to prepare and burn
a DVD right from Kino.

%prep
%setup
%patch1 -p1
%patch2 -p2
%patch3 -p1
%patch4 -p2
bzcat %SOURCE5 > po/ru.po

%build
export LDFLAGS=-export-dynamic
%autoreconf
%configure \
	%{subst_with quicktime} \
	--with-avcodec

touch po/stamp-it
%make_build

%install
%makeinstall_std
install -p %SOURCE4 %buildroot%_desktopdir/Kino.desktop
mkdir -p %buildroot%_sysconfdir/kino-scripts
rm -f %buildroot%_libdir/kino-gtk2/*.{a,la}
%find_lang --with-gnome %name
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Application \
	--add-category=Video \
	--add-category=AudioVideoEditing \
	%buildroot%_desktopdir/Kino.desktop

%post
UUU=%_sbindir/update-usb.usermap
[ ! -x "$UUU" ] || "$UUU"

%postun
if [ "$1" = 0 ]; then
	UUU=%_sbindir/update-usb.usermap
	[ ! -x "$UUU" ] || "$UUU"
fi

%files -f %name.lang
%_bindir/*
%_datadir/%name/
%exclude %_datadir/%name/scripts/dvdauthor/
%_pixmapsdir/*
%_desktopdir/*
%_man1dir/*
%dir %_libdir/kino-gtk2/
# NB: *.so belong to kino package too, these are plugins!
%_libdir/kino-gtk2/*.so*
%_datadir/mime/packages/*.xml
%_sysconfdir/udev/rules.d/*
%dir %_sysconfdir/kino-scripts/
%doc AUTHORS BUGS ChangeLog NEWS README* TODO

%files devel
%_includedir/*

#files dvdauthor
#_datadir/%name/scripts/dvdauthor/

%changelog
