# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: libArcus
Version: 4.7.1
Release: alt1

Summary: Communication library between internal components for Ultimaker software
License: LGPLv3+
Group: Development/Other
Url: https://github.com/Ultimaker/libArcus

Packager: Anton Midyukov <antohami@altlinux.org>

Source: %name-%version.tar
Patch: fix_find_sip.patch

BuildRequires(pre): rpm-build-python3 rpm-macros-cmake
BuildRequires: python3-dev cmake gcc-c++ pkgconfig(protobuf) python3-module-sip-devel protobuf-compiler

%description
%summary

%package devel
Summary: Development files for %name
Group:   Development/Other
Requires: %name

%description devel
Development files for %name.

%package -n python3-module-Arcus
Summary: Communication library between internal components for Ultimaker software
Group:   Development/Python3
%py3_provides Arcus
Requires: %name

%description -n python3-module-Arcus
Communication library between internal components for Ultimaker software

%prep
%setup
%patch -p1

# https://github.com/Ultimaker/libArcus/pull/94#issuecomment-505376760
sed -i 's/Python3_SITELIB/Python3_SITEARCH/' cmake/SIPMacros.cmake

%build
%cmake -DBUILD_EXAMPLES:BOOL=OFF \
       -DCMAKE_SKIP_RPATH:BOOL=ON
%cmake_build

%install
%cmakeinstall_std

%files
%_libdir/*.so.*
%doc LICENSE README.md

%files devel
%_libdir/*.so
%_includedir/Arcus
%_libdir/cmake/Arcus

%files -n python3-module-Arcus
%python3_sitelibdir/*

%changelog
