%def_enable pulse

Name: libao
Version: 1.2.2
Release: alt3
Epoch: 1

Summary: Cross Platform Audio Output Library
License: GPL
Group: System/Libraries

Url: http://www.xiph.org/ao/
# https://git.xiph.org/libao.git
Source0: %name-%version.tar
Patch0: libao-1.0.0-alt-oss.patch

BuildRequires: libalsa-devel
%{?_enable_pulse:BuildRequires: libpulseaudio-devel}

Provides: %name-alsa = %version-%release
Obsoletes: %name-alsa < %version-%release

%description
Libao is a cross platform audio output library.
It currently supports ALSA and PULSE.

%package pulse
Summary: PulseAudio output plugin for libao
Group: System/Libraries
Requires: %name = %version-%release

%description pulse
This is package contains PulseAudio output plugin for libao

%package devel
Summary: Development files for %name
Group: Development/C
PreReq: %name = %version-%release

%description devel
The %name-devel package contains the header files and documentation
needed to develop applications with %name

%prep
%setup
%patch -p1
sed -i 's,-O20,%optflags_optimization,g' configure*

%build
%autoreconf
%configure \
	--enable-pulse \
	--enable-alsa \
	--disable-alsa-mmap \
	--disable-broken-oss \
	--disable-oss \
	--disable-esd \
	--disable-arts \
	--disable-nas
%make_build

%install
%makeinstall_std

mkdir -p %buildroot%_sysconfdir
cat <<__EOF__ >%buildroot%_sysconfdir/%name.conf
# possible values for "default_driver" are: alsa, pulse
default_driver=alsa
__EOF__

%files
%config(noreplace) %_sysconfdir/%name.conf
%_libdir/*.so.*
%dir %_libdir/ao
%dir %_libdir/ao/plugins-4
%_libdir/ao/plugins-4/libalsa.so
%_man5dir/*

%if_enabled pulse
%files pulse
%_libdir/ao/plugins-4/libpulse.so
%endif

%files devel
%doc AUTHORS CHANGES TODO doc/*.{html,css,c}
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/aclocal/*

%changelog
