Name: libdbus-glib
Version: 0.106
Release: alt1
Epoch: 1
Summary: GLib bindings for D-BUS
License: GPL or Academic Free License
Group: System/Libraries
URL: http://www.freedesktop.org/wiki/Software/DBusBindings
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: dbus doxygen gcc-c++ glib2-devel libdbus-devel libexpat-devel libgio-devel xmlto gtk-doc

%description
This package contains D-BUS library wrapper suitable for applications
which make use of GLib event loop.

%package devel
Summary: GLib bindings development files for D-BUS
Group: Development/C
Requires: %name = %version-%release
PreReq: libdbus-devel >= 0.94
Requires: glib2-devel

%description devel
This package contains GLib bindings development files for D-BUS.

%package doc
Summary: GLib bindings documentation for D-BUS
Group: Development/C
Requires: %name = %version-%release
BuildArch: noarch

%description doc
This package contains GLib bindings documentation files for D-BUS.

%prep
%setup -q
%patch -p1

%build
gtkdocize
%autoreconf
%configure \
	--libexecdir=%_prefix/libexec/dbus-1 \
	--enable-gtk-doc \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot install

%files 
%doc AUTHORS HACKING NEWS README
%_sysconfdir/bash_completion.d/*.sh
%_libdir/lib*.so.*
%_prefix/libexec/dbus-1/dbus-bash-completion-helper

%files devel
%_includedir/dbus-1.0/dbus/dbus*.h
%_bindir/dbus-binding-tool
%_libdir/lib*.so
%_pkgconfigdir/dbus-glib-1.pc
%_man1dir/dbus-binding-tool.1*

%files doc
%_datadir/gtk-doc/html/dbus-glib

%changelog
