%define _name libevent
Name: %{_name}2
Version: 2.0.22
Release: alt2

Summary: An asynchronous event notification library
Group: System/Libraries
License: BSD-style
Url: http://www.monkey.org/~provos/libevent/

# http://www.monkey.org/~provos/libevent-%version-stable.tar.gz
Source: %name-%version.tar
Source1: Makefile.sample
Source2: README.libevent
# git://git.altlinux.org/gears/l/%name.git
Patch: %_name-%version-%release.patch

%def_disable static
BuildRequires: libssl-devel zlib-devel

%description
The libevent API provides a mechanism to execute a callback function
when a specific event occurs on a file descriptor or after a timeout
has been reached.

libevent is meant to replace the asynchronous event loop found in
event driven network servers.  Currently, libevent supports kqueue(2),
select(2) and epoll(4).

%prep
%setup
%patch -p1

%build
%autoreconf
# force epoll and /dev/epoll support
export haveepoll=yes
%configure %{subst_enable static} --disable-libevent-regress
%make_build

%install
%makeinstall_std

# Relocate shared libraries from %_libdir/ to /%_lib/.
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/*.so; do
	t=$(readlink "$f") || continue
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

%define docdir %_docdir/%name-%version
install -pD -m644 %_sourcedir/Makefile.sample \
	%buildroot%docdir/examples/Makefile
install -p -m644 sample/*.c %buildroot%docdir/examples/
install -pm644 %_sourcedir/README.libevent \
	%buildroot%docdir/README

#Install man
mkdir -p %buildroot%_man3dir
install -p -m644 *.3 %buildroot%_man3dir/

%check
make verify

%files
/%_lib/*.so.*
%dir %docdir
%docdir/README

%changelog
