Name: libexplain
Version: 1.4
Release: alt1

Summary: Library functions to explain system call errors

Url: http://libexplain.sourceforge.net

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://downloads.sourceforge.net/%name/%name-%version.tar
Patch: libexplain-1.4-syscall.patch
Patch1: libexplain-1.4-largefile.patch
Patch2: libexplain-1.4-missed-defines.patch

License: LGPLv3+
Group: System/Libraries

BuildRequires: bison libacl-devel libcap-devel libtool lsof gettext-tools
BuildRequires: ghostscript-utils groff-base groff-ps

%{!?_pkgdocdir: %global _pkgdocdir %_docdir/%name-%version}

%description
The libexplain project provides a library which may be used to explain
Unix and Linux system call errors. This will make your application's
error messages much more informative to your users.  The library is
not quite a drop-in replacement for strerror, but it comes close. Each
system call has a dedicated libexplain function.

The coverage for system calls is being improved all the time. Coverage
includes 159 system calls and 444 ioctl requests.

%package -n explain
Summary: Explains system call error reports
License: GPLv3+
Group: Development/Tools

%description -n explain
The explain command is used to decode an error return read from an
strace(1) listing, or similar.  Because this is being deciphered in a
different process than the original, the results will be less accurate
than if the program itself were to use libexplain(3).

%package devel
Summary: Development files for libexplain
License: LGPLv3+ and GPLv3+
Group: Development/C
Requires: libexplain = %version-%release
Requires: pkg-config

%description devel
Development files for the libexplain library.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1

# In some releases of libexplain, some tests fail in a way that does
# not indicate a fault in libexplain. Skip those tests.  Note that
# Makefile.in is automatically generated upstream, and if we use a
# patch against it, the patch will usually break with each new
# upstream release.  Instead we use sed to patch it.

# t0524a fails for mock/koji builds, but succeeds for normal builds.
# This may be due to the use of a chroot environment.  I reported this
# problem on the libexplain mailing list on 22-JAN-2012 and 11-MAR-2012,
# but as of 8-JUL-2012 there has been no response.  It appears to be
# fixed as of version 1.4.

# t0555a failure observed in version 1.2 on Fedora 19.  I reported this
# problem on the libexplain mailing list on 4-JUN-2013.  It was fixed in
# version 1.3.

#%define skiptests t0524a t0555a
#
#for t in %skiptests
#do
#  sed -i "s/\([ \t]\)$t\([ \t]\)/\1/g" Makefile.in
#done

# Propagate %%{_pkgdocdir} into Makefile.in
case "%_pkgdocdir" in
*/libexplain-%version )
  sed -i "s,\$(datarootdir)/doc/libexplain,\$(datarootdir)/doc/libexplain-%version," Makefile.in
  ;;
esac

%build
# formerly used --disable-static, but configure says it is unrecognized
%configure

%make_build

%check
# TODO: 
# Invalid argument (EINVAL) because unknown protocol, or protocol family not available
# FAILED test of socket EPROTONOSUPPORT
make check || :

%install
# The install target is not smp-safe, so don't use smp_mflags.
make DESTDIR=%buildroot \
     install
# The shared library has to be executable!
chmod 755 %buildroot%_libdir/%name.so.*.*.*
# Get rid of the static library and libtool archives
rm %buildroot%_libdir/%name.{a,la}

# Add files to docs
install -m 0664 README LICENSE %buildroot%_pkgdocdir


%files
%_libdir/%name.so.*
%_datadir/locale/de/LC_MESSAGES/%name.mo
%dir %doc %_pkgdocdir
%doc %_pkgdocdir/README
%doc %_pkgdocdir/LICENSE
%doc %_pkgdocdir/readme.pdf
%doc %_pkgdocdir/reference.pdf

%files -n explain
%_bindir/explain
%_man1dir/*.1.*

%files devel
%_man3dir/*.3.*
%_includedir/%name/
%_libdir/%name.so
%_pkgconfigdir/%name.pc
%dir %doc %_pkgdocdir
%doc %_pkgdocdir/building.pdf
%doc %_pkgdocdir/new_system_call.pdf

# NOTE rpmlint will complain about a use of mktemp.  This is because libexplain
# provides a wrapper for mktemp, not because it is used.

%changelog
